/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004  Alexander Dymo <cloudtemple@mskat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "urledit.h"

#include <tqlayout.h>
#include <tqvariant.h>

#include <kurlrequester.h>
#include <klineedit.h>

#include "property.h"


using namespace KoProperty;

URLEdit::URLEdit(Property *property, TQWidget *parent, const char *name)
 : Widget(property, parent, name)
{
	TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
	m_edit = new KURLRequester(this);
	m_edit->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding);
	m_edit->setMinimumHeight(5);
	l->addWidget(m_edit);

	setProperty(property);

	connect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotValueChanged(const TQString&)));
	m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
}

URLEdit::~URLEdit()
{}

TQVariant
URLEdit::value() const
{
	return m_edit->url();
}

void
URLEdit::setValue(const TQVariant &value, bool emitChange)
{
	m_edit->blockSignals(true);
	m_edit->setURL(value.toString());
	m_edit->blockSignals(false);
	if (emitChange)
		emit valueChanged(this);
}

void
URLEdit::slotValueChanged(const TQString&)
{
	emit valueChanged(this);
}

void
URLEdit::setProperty(Property *property)
{
	int  mode;
	if(property) {
		switch(property->type()) {
			case DirectoryURL:  mode = KFile::Directory|KFile::ExistingOnly;  break;
			case FileURL: case PictureFileURL: default: mode = KFile::File|KFile::ExistingOnly;
		}
		m_edit->setMode(mode);
	}

	Widget::setProperty(property);
}

void
URLEdit::setReadOnlyInternal(bool readOnly)
{
	m_edit->lineEdit()->setReadOnly(readOnly);
	m_edit->button()->setEnabled(!readOnly);
}

#include "urledit.moc"
