/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004  Alexander Dymo <cloudtemple@mskat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/
#include "combobox.h"

#include <tqlayout.h>
#include <tqmap.h>
#include <tqvariant.h>
#include <tqpainter.h>

#include <kcombobox.h>
#include <kdebug.h>

#include "property.h"

using namespace KoProperty;

ComboBox::ComboBox(Property *property, TQWidget *parent, const char *name)
 : Widget(property, parent, name)
 , m_setValueEnabled(true)
{
	TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
	m_edit = new KComboBox(this);
	m_edit->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding);
	m_edit->setMinimumHeight(5);
	l->addWidget(m_edit);

	m_edit->setEditable(false);
	m_edit->setInsertionPolicy(TQComboBox::NoInsertion);
	m_edit->setMinimumSize(10, 0); // to allow the combo to be resized to a small size
	m_edit->setAutoCompletion(true);
	m_edit->setContextMenuEnabled(false);

	if (this->property()->listData()) {
		fillBox();
	}
//not needed for combo	setLeavesTheSpaceForRevertButton(true);

	setFocusWidget(m_edit);
	connect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(slotValueChanged(int)));
}

ComboBox::~ComboBox()
{
}

TQVariant
ComboBox::value() const
{
	if (!property()->listData()) {
		kopropertywarn << "ComboBox::value(): propery listData not available!" << endl;
		return TQVariant();
	}
	const int idx = m_edit->currentItem();
	if (idx<0 || idx>=(int)property()->listData()->keys.count())
		return TQVariant();
	return TQVariant( property()->listData()->keys[idx] );
//	if(property()->listData() && property()->listData()->contains(m_edit->currentText()))
//		return (*(property()->valueList()))[m_edit->currentText()];
//	return TQVariant();
}

void
ComboBox::setValue(const TQVariant &value, bool emitChange)
{
	if (!property() || !property()->listData()) {
		kopropertywarn << "ComboBox::value(): propery listData not available!" << endl;
		return;
	}
	if (!m_setValueEnabled)
		return;
	int idx = property()->listData()->keys.findIndex( value );
	if (idx>=0 && idx<m_edit->count()) {
		m_edit->setCurrentItem(idx);
	}
	else {
		if (idx<0) {
			kopropertywarn << "ComboBox::setValue(): NO SUCH KEY '" << value.toString() 
				<< "' (property '" << property()->name() << "')" << endl;
		} else {
			TQStringList list;
			for (int i=0; i<m_edit->count(); i++)
				list += m_edit->text(i);
			kopropertywarn << "ComboBox::setValue(): NO SUCH INDEX WITHIN COMBOBOX: " << idx 
				<< " count=" << m_edit->count() << " value='" << value.toString() 
				<< "' (property '" << property()->name() << "')\nActual combobox contents: "
				<< list << endl;
		}
		m_edit->setCurrentText(TQString());
	}

	if(value.isNull())
		return;

//	m_edit->blockSignals(true);
//	m_edit->setCurrentText(keyForValue(value));
//	m_edit->blockSignals(false);
	if (emitChange)
		emit valueChanged(this);
}

void
ComboBox::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value)
{
	TQString txt;
	if (property()->listData()) {
		const int idx = property()->listData()->keys.findIndex( value );
		if (idx>=0)
			txt = property()->listData()->names[ idx ];
	}

	Widget::drawViewer(p, cg, r, txt); //keyForValue(value));
//	p->eraseRect(r);
//	p->drawText(r, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine, keyForValue(value));
}

void
ComboBox::fillBox()
{
	m_edit->clear();
	//m_edit->clearContents();

	if(!property())
		return;
	if (!property()->listData()) {
		kopropertywarn << "ComboBox::fillBox(): propery listData not available!" << endl;
		return;
	}

	m_edit->insertStringList(property()->listData()->names);
	TDECompletion *comp = m_edit->completionObject();
	comp->insertItems(property()->listData()->names);
	comp->setCompletionMode(TDEGlobalSettings::CompletionShell);
}

void
ComboBox::setProperty(Property *prop)
{
	const bool b = (property() == prop);
	m_setValueEnabled = false; //setValue() couldn't be called before fillBox()
	Widget::setProperty(prop);
	m_setValueEnabled = true;
	if(!b)
		fillBox();
	if(prop)
		setValue(prop->value(), false); //now the value can be set
}

void
ComboBox::slotValueChanged(int)
{
	emit valueChanged(this);
}

void
ComboBox::setReadOnlyInternal(bool readOnly)
{
	setVisibleFlag(!readOnly);
}


/*TQString
ComboBox::keyForValue(const TQVariant &value)
{
	const TQStringVariantMap *list = property()->valueList();
	Property::ListData *list = property()->listData();

	if (!list)
		return TQString();
	int idx = listData->keys.findIndex( value );


	TQStringVariantMap::ConstIterator endIt = list->constEnd();
	for(TQStringVariantMap::ConstIterator it = list->constBegin(); it != endIt; ++it) {
		if(it.data() == value)
			return it.key();
	}
	return TQString();
}*/


#include "combobox.moc"

