/*
 *  Copyright (c) 1999 Matthias Elter (me@kde.org)
 *  Copyright (c) 2001-2002 Igor Jansen (rm@kde.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef KO_GRAY_WIDGET_H
#define KO_GRAY_WIDGET_H

#include "tqwidget.h"

#include <koffice_export.h>
#include <kdualcolorbutton.h>

class KoFrameButton;
class TQGridLayout;
class TQColor;
class KoColorSlider;
class TQLabel;
class TQSpinBox;
class KDualColorButton;

class KoGrayWidget
     : public TQWidget
{
    TQ_OBJECT
  
    typedef TQWidget super;

public:
    KoGrayWidget(TQWidget *parent = 0L, const char *name = 0);
    virtual ~KoGrayWidget() {}

public slots:
    /**
     * Set the current color to c. Do not emit the color changed signals
     */
    virtual void setFgColor(const TQColor & c);
    virtual void setBgColor(const TQColor & c);

signals:

    /**
     * Emitted when the current color is changed.
     */
    virtual void sigFgColorChanged(const TQColor & c);
    virtual void sigBgColorChanged(const TQColor & c);

protected slots:
    virtual void slotChanged(int v);

    void slotFGColorSelected(const TQColor& c);
    void slotBGColorSelected(const TQColor& c);
    void currentChanged(KDualColorButton::DualColor);

private:

    void update(const TQColor & fgColor, const TQColor & bgColor);

    KoColorSlider *mSlider;
    TQLabel *mLabel;
    TQSpinBox *mIn;
    KDualColorButton *m_ColorButton;

    TQColor m_fgColor;
    TQColor m_bgColor;
};

#endif
