/* This file is part of the KDE project
   Copyright (C) 2005 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/


#include <tqlabel.h>
#include <tqlayout.h>
#include <tqmultilineedit.h>
#include <tqpushbutton.h>
#include <tqtoolbutton.h>
#include <tqapplication.h>
#include <tqlayout.h>
#include <kiconloader.h>
#include <kbuttonbox.h>
#include <kdebug.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <tdelistview.h>
#include <kdebug.h>

#include <tqmultilineedit.h>

#include "Koversiondialog.h"


KoVersionDialog::KoVersionDialog( TQWidget* parent,  const char* name )
    : KDialogBase( parent, name, true, i18n("Version"), Ok|Cancel )
{
  TQWidget* page = new TQWidget( this );
  setMainWidget( page );

  TQGridLayout *grid1 = new TQGridLayout( page,10,3,KDialog::marginHint(), KDialog::spacingHint());

  list=new TDEListView(page,  "versionlist");
  list->addColumn(i18n("Date & Time"));
  list->addColumn(i18n("Saved By"));
  list->addColumn(i18n("Comment"));

  grid1->addMultiCellWidget(list,0,8,0,0);

  m_pAdd=new TQPushButton(i18n("&Add"),page);
  grid1->addWidget(m_pAdd,1,2);

  m_pRemove=new TQPushButton(i18n("&Remove"),page);
  grid1->addWidget(m_pRemove,2,2);

  m_pModify=new TQPushButton(i18n("&Modify"),page);
  grid1->addWidget(m_pModify,3,2);

  m_pOpen=new TQPushButton(i18n("&Open"),page);
  grid1->addWidget(m_pOpen,4,2);


  connect( m_pRemove, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotRemove() ) );
  connect( m_pAdd, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotAdd() ) );
  connect( m_pOpen, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotOpen() ) );
  connect( m_pModify, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotModify() ) );

  updateButton();

  resize( 600, 250 );

}

KoVersionDialog::~KoVersionDialog()
{
}

void KoVersionDialog::updateButton()
{
#if 0
    bool state = ( list->currentItem() >= 0 );
    m_pRemove->setEnabled( state );
#endif
}

void KoVersionDialog::slotAdd()
{
    //TODO create entry
}

void KoVersionDialog::slotRemove()
{
    //TODO remove entry
}

void KoVersionDialog::slotModify()
{
    KoVersionModifyDialog * dlg = new KoVersionModifyDialog(  this /*, const TQString &_comment*/ /*TODO add*/ );
    if ( dlg->exec() )
    {
        //TODO
        kdDebug()<<" comment :"<<dlg->comment()<<endl;
    }
    delete dlg;

}

void KoVersionDialog::slotOpen()
{
    //TODO open file
}

void KoVersionDialog::slotOk()
{
    accept();
}

KoVersionModifyDialog::KoVersionModifyDialog(  TQWidget* parent, const TQString &/*comment*/, const char* name )
    : KDialogBase( parent, name, true, i18n("Comment"), Ok|Cancel )
{
    TQWidget* page = new TQWidget( this );
    setMainWidget( page );

    TQHBoxLayout *grid1 = new TQHBoxLayout( page,KDialog::marginHint(), KDialog::spacingHint());

    m_multiline=new TQMultiLineEdit(page, "multiline");
    grid1->addWidget( m_multiline );

}

TQString KoVersionModifyDialog::comment() const
{
    return m_multiline->text();
}


#include "Koversiondialog.moc"
