/* This file is part of the KDE project
   Copyright (C) 2001 Thomas Zander <zander@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef splitcelldia_h
#define splitcelldia_h

#include <kdialogbase.h>
#include <tqptrlist.h>

#include "defs.h"

class TQGridLayout;
class TQLabel;
class TQCheckBox;
class TQSpinBox;
class KWTablePreview;

class KWSplitCellDia : public KDialogBase {
    TQ_OBJECT
  

public:
    KWSplitCellDia( TQWidget *parent, const char *name, unsigned int numcols, unsigned int numrows);

    unsigned int rows()const { return m_rows; }
    unsigned int columns()const { return m_cols; }

protected:
    TQSpinBox *nRows, *nCols;
    KWTablePreview *preview;

    unsigned int m_rows, m_cols;

protected slots:
    void rowsChanged( int );
    void colsChanged( int );
};

#endif


