/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KWFactory.h"
#include "KWAboutData.h"
#include "KWDocument.h"

#include <kstandarddirs.h>

#include <kiconloader.h>

TDEInstance* KWFactory::s_instance = 0;
TDEAboutData* KWFactory::s_aboutData = 0;

KWFactory::KWFactory( TQObject* parent, const char* name )
    : KoFactory( parent, name )
{
  // Create our instance, so that it becomes TDEGlobal::instance if the
  // main app is KWord.
  (void) instance();
}

KWFactory::~KWFactory()
{
    delete s_aboutData;
    s_aboutData=0;
    delete s_instance;
    s_instance=0L;
}

KParts::Part* KWFactory::createPartObject( TQWidget *parentWidget, const char *widname, TQObject* parent, const char* name, const char* classname, const TQStringList & )
{
    bool bWantKoDocument = ( strcmp( classname, "KoDocument" ) == 0 );

    KWDocument *doc = new KWDocument( parentWidget, widname, parent, name, !bWantKoDocument );

    if ( !bWantKoDocument )
      doc->setReadWrite( false );

    return doc;
}

TDEAboutData* KWFactory::aboutData()
{
    if(!s_aboutData) {
        s_aboutData = newKWordAboutData();
    }
    return s_aboutData;
}

TDEInstance* KWFactory::instance()
{
    if ( !s_instance )
    {
      s_instance = new TDEInstance( aboutData() );

      s_instance->dirs()->addResourceType( "kword_template",
              TDEStandardDirs::kde_default("data") + "kword/templates/");
      s_instance->dirs()->addResourceType( "expression", TDEStandardDirs::kde_default("data") + "kword/expression/");
      s_instance->dirs()->addResourceType( "horizontalLine", TDEStandardDirs::kde_default("data") + "kword/horizontalline/");

      s_instance->dirs()->addResourceType( "toolbar",
              TDEStandardDirs::kde_default("data") + "koffice/toolbar/");
      s_instance->dirs()->addResourceType( "toolbar",
              TDEStandardDirs::kde_default("data") + "kformula/pics/");
      s_instance->iconLoader()->addAppDir("koffice");
    }
    return s_instance;
}

#include "KWFactory.moc"
