/* This file is part of the KDE project
   Copyright (C) 2002-2003 Norbert Andres <nandres@web.de>
             (C) 2002 Ariya Hidayat <ariya@kde.org>
             (C) 2002 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kspread_dlg_database__
#define __kspread_dlg_database__

#include <tqdialog.h>
#include <tqrect.h>

#include <kwizard.h>

class TQCheckBox;
class TQComboBox;
class TQFrame;
class TQGridLayout;
class TQLabel;
class TQLineEdit;
class TQListViewItem;
class TQHBoxLayout;
class TQRadioButton;
class TQSqlDatabase;
class TQTextEdit;
class TQVBoxLayout;
class TQWidget;

class TDEListView;
class KPushButton;
namespace KSpread
{
class View;

class DatabaseDialog : public KWizard
{
  TQ_OBJECT
  

 public:
  enum PageId { eDatabase = 0, eSheets = 1, eColumns = 2, eOptions = 3, eResult = 4 };

  DatabaseDialog( View * parent, TQRect const & rect, const char * name = 0, bool modal = FALSE, WFlags fl = 0 );
  virtual ~DatabaseDialog();

 private slots:
  void orBox_clicked();
  void andBox_clicked();
  void startingCell_clicked();
  void startingRegion_clicked();
  void connectButton_clicked();
  void databaseNameChanged( const TQString & s );
  void databaseHostChanged( const TQString & s );
  void databaseDriverChanged( int );
  void popupSheetViewMenu( TQListViewItem *, const TQPoint &, int );
  void sheetViewClicked( TQListViewItem * );
  void accept();

 protected:
  void next();
  void back();

  TQGridLayout  * m_databaseLayout;
  TQGridLayout  * m_sheetLayout;
  TQGridLayout  * m_columnsLayout;
  TQGridLayout  * m_optionsLayout;
  TQGridLayout  * m_resultLayout;

 private:
  int            m_currentPage;
  View  * m_pView;
  TQRect          m_targetRect;
  TQSqlDatabase * m_dbConnection;

  TQWidget      * m_database;
  TQLabel       * m_databasetStatus;
  TQLineEdit    * m_username;
  TQLineEdit    * m_port;
  TQLineEdit    * m_databaseName;
  TQComboBox    * m_driver;
  TQLineEdit    * m_password;
  TQLineEdit    * m_host;
  TQLabel       * m_Type;
  TQWidget      * m_sheet;
  TQComboBox    * m_databaseList;
  KPushButton  * m_connectButton;
  TQLabel       * m_sheetStatus;
  TQLabel       * m_SelectSheetLabel;
  TDEListView    * m_sheetView;
  TQWidget      * m_columns;
  TDEListView    * m_columnView;
  TQLabel       * m_columnsStatus;
  TQWidget      * m_options;
  TQComboBox    * m_columns_1;
  TQComboBox    * m_columns_2;
  TQComboBox    * m_columns_3;
  TQComboBox    * m_operator_1;
  TQComboBox    * m_operator_2;
  TQComboBox    * m_operator_3;
  TQLineEdit    * m_operatorValue_1;
  TQLineEdit    * m_operatorValue_2;
  TQLineEdit    * m_operatorValue_3;
  TQRadioButton * m_andBox;
  TQRadioButton * m_orBox;
  TQComboBox    * m_columnsSort_1;
  TQComboBox    * m_columnsSort_2;
  TQComboBox    * m_sortMode_1;
  TQComboBox    * m_sortMode_2;
  TQCheckBox    * m_distinct;
  TQWidget      * m_result;
  TQTextEdit    * m_sqlQuery;
  TQRadioButton * m_startingRegion;
  TQLineEdit    * m_cell;
  TQLineEdit    * m_region;
  TQRadioButton * m_startingCell;

  void switchPage( int id );
  bool databaseDoNext();
  bool sheetsDoNext();
  bool columnsDoNext();
  bool optionsDoNext();

  TQString exchangeWildcards(TQString const & value);
  TQString getWhereCondition( TQString const &, TQString const &, int );
};

} // namespace KSpread

#endif
