#ifndef __textpreview_h__
#define __textpreview_h__

#include <tqframe.h>
#include "global.h"

class KPrTextPreview : public TQFrame
{
    TQ_OBJECT
  

public:
    KPrTextPreview( TQWidget* parent, const char* name = 0 );
    ~KPrTextPreview() {}

    void setShadowDirection( ShadowDirection sd ) { shadowDirection = sd; repaint( true ); }
    void setShadowDistance( int sd ) { shadowDistance = sd; repaint( true ); }
    void setShadowColor( const TQColor &sc ) { shadowColor = sc; repaint( true ); }
    void setAngle( double a ) { angle = a; repaint( true ); }

protected:
    void drawContents( TQPainter* );

    ShadowDirection shadowDirection;
    int shadowDistance;
    TQColor shadowColor;
    double angle;
};

#endif

