/* This file is part of the KDE project
   Copyright (C) 2002 Toshitaka Fujioka <fujioka@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef presdurationdia_h
#define presdurationdia_h

#include <kdialogbase.h>

class KPrDocument;
class TDEListView;
class TQLabel;

class KPrPresDurationDia : public KDialogBase
{
    TQ_OBJECT
  

public:
    KPrPresDurationDia( TQWidget *parent, const char *name,
                       KPrDocument *_doc,
                       TQStringList _durationListString,
                       const TQString &_durationString );

protected:
    void setupSlideList( TQWidget *_page );

private:
    KPrDocument *doc;
    TDEListView *slides;
    TQLabel *label;

    TQStringList m_durationListString;
    TQString m_durationString;

protected slots:
    void slotCloseDialog() { emit presDurationDiaClosed(); }

signals:
    void presDurationDiaClosed();

};

#endif
