/* This file is part of the KDE project
   Copyright (C)  2002 Montel Laurent <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tdelocale.h>
#include "KPrDocument.h"
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlistbox.h>
#include <tdemessagebox.h>
#include "KPrImportStyleDia.h"
#include <KoStore.h>
#include <tqfile.h>
#include <tdefiledialog.h>
#include <kdebug.h>
#include <tqlabel.h>
#include "KPrTextObject.h"

KPrImportStyleDia::KPrImportStyleDia( KPrDocument *_doc, KoStyleCollection* currentCollection,
                                      TQWidget *parent, const char *name )
    :KoImportStyleDia( currentCollection, parent, name ),
     m_doc(_doc)
{
}

KPrImportStyleDia::~KPrImportStyleDia()
{
}

void KPrImportStyleDia::loadFile()
{
    KFileDialog fd( TQString(), TQString(), 0, 0, TRUE );
    TQStringList lst = "application/x-kpresenter";
#if 0 //For the future
    lst << "application/vnd.oasis.opendocument.presentation";
#endif
    fd.setMimeFilter( lst );
    fd.setCaption(i18n("Import Style"));
    KURL url;
    if ( fd.exec() != TQDialog::Accepted )
        return;
    url = fd.selectedURL();
    if( url.isEmpty() )
    {
        KMessageBox::sorry( this,
                            i18n("File name is empty."),
                            i18n("Import Style"));
        return;
    }
    TQMap<TQString, TQString>insertStyle;
    KoStore* store=KoStore::createStore( this, url.path(), KoStore::Read );
    if (store )
    {
        if (store->open("maindoc.xml") )
        {
            clear();
            m_listStyleName->clear();

            TQDomDocument doc;
            doc.setContent( store->device() );
            TQDomElement word = doc.documentElement();

            TQDomElement stylesElem = word.namedItem( "STYLES" ).toElement();
            if ( !stylesElem.isNull() )
            {
                //todo
                //duplicate code try to remove it !
                TQValueList<TQString> followingStyles;
                TQDomNodeList listStyles = stylesElem.elementsByTagName( "STYLE" );
                for (unsigned int item = 0; item < listStyles.count(); item++)
                {
                    TQDomElement styleElem = listStyles.item( item ).toElement();

                    KoParagStyle *sty = new KoParagStyle( TQString() );
                    // Load the style from the <STYLE> element
                    sty->loadStyle( styleElem );

                    if ( currentCollection()->findStyle( sty->name() ) )
                        sty->setName(generateStyleName(sty->name() + "-%1"));
                    TQString name = sty->displayName();
                    // ### TODO: we should offer the option of updating the
                    // existing style instead of creating a foo-1 style. Any ideas for a GUI?
                    if ( currentCollection()->findStyleByDisplayName( name ) )
                        sty->setDisplayName(generateStyleDisplayName(sty->displayName() + "-%1"));
                    insertStyle.insert( name, sty->name() );

                    TQDomElement formatElem = styleElem.namedItem( "FORMAT" ).toElement();
                    if ( !formatElem.isNull() )
                        sty->format() = KPrTextObject::loadFormat( formatElem, 0L, m_doc->defaultFont(),
                                                                  m_doc->globalLanguage(), m_doc->globalHyphenation() );
                    else
                        kdWarning(33001) << "No FORMAT tag in <STYLE>" << endl; // This leads to problems in applyStyle().


                    // Style created, now let's try to add it
                    sty = m_styleList.addStyle(sty);

                    if( m_styleList.count() >= 0 && uint( m_styleList.count() ) > followingStyles.count() )
                    {
                        TQString following = styleElem.namedItem("FOLLOWING").toElement().attribute("name");
                        followingStyles.append( following );
                    }
                    else
                        kdWarning(33001) << "Found duplicate style declaration, overwriting former " << sty->name() << endl;
                }

                Q_ASSERT( m_styleList.count() >= 0 && followingStyles.count() == uint( m_styleList.count() ) );

                unsigned int i=0;
                for( TQValueList<TQString>::Iterator it = followingStyles.begin(); it != followingStyles.end(); ++it ) {
                    TQString newName =*it;
                    if ( insertStyle.contains( *it ) )
                        newName = (insertStyle)[ *it ];

                    KoParagStyle * style = m_styleList.findStyle(newName);
                    if ( style )
                        m_styleList.styleAt(i++)->setFollowingStyle( style );
                }

            }
            initList();
        }
        else if ( store->hasFile( "content.xml" ) )
        {
            //oasis file format (for koffice-1.5)
        }
        else
        {
            KMessageBox::error( this,
                                i18n("File is not a KPresenter file!"),
                                i18n("Import Style"));
        }
        store->close();
    }
    delete store;
}


#include "KPrImportStyleDia.moc"
