/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>
   Copyright (C) 2005 Thorsten Zachmann <zachmann@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef kpautoformobject_h
#define kpautoformobject_h

#include <tqpixmap.h>
#include <KoBrush.h>

#include "KPrObject.h"
#include "global.h"
#include "autoformEdit/ATFInterpreter.h"

class KPrGradient;
class DCOPObject;

class KPrAutoformObject : public KPr2DObject, public KPrStartEndLine
{
public:
    KPrAutoformObject();
    KPrAutoformObject( const KoPen & _pen, const TQBrush &_brush, const TQString &_filename, LineEnd _lineBegin, LineEnd _lineEnd,
                      FillType _fillType, const TQColor &_gColor1, const TQColor &_gColor2, BCType _gType,
                      bool _unbalanced, int _xfactor, int _yfactor);
    virtual ~KPrAutoformObject() {}

    KPrAutoformObject &operator=( const KPrAutoformObject & );

    virtual DCOPObject* dcopObject();

    virtual void setFileName( const TQString &_filename );
    virtual void setLineBegin( LineEnd _lineBegin )
        { lineBegin = _lineBegin; }
    virtual void setLineEnd( LineEnd _lineEnd )
        { lineEnd = _lineEnd; }

    virtual ObjType getType() const
        { return OT_AUTOFORM; }
    virtual TQString getTypeString() const
        { return i18n("Autoform"); }

    TQString getFileName() const
        { return filename; }
    virtual LineEnd getLineBegin() const
        { return lineBegin; }
    virtual LineEnd getLineEnd() const
        { return lineEnd; }

    virtual TQDomDocumentFragment save( TQDomDocument& doc,double offset );

    virtual double load(const TQDomElement &element);
protected:
    virtual const char * getOasisElementName() const;
    virtual bool saveOasisObjectAttributes( KPOasisSaveContext &sc ) const;
    virtual void fillStyle( KoGenStyle& styleObjectAuto, KoGenStyles& mainStyles ) const;

    virtual void paint( TQPainter *_painter, KoTextZoomHandler *_zoomHandler,
                        int /* pageNum */, bool drawingShadow, bool drawContour = FALSE );

    TQString filename;

    ATFInterpreter atfInterp;
};

#endif
