/* This file is part of the KDE project
   Copyright (C) 2004 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kexinamedialog.h"

KexiNameDialog::KexiNameDialog(const TQString& message, 
	TQWidget * parent, const char * name)
 : KDialogBase(KDialogBase::Plain, TQString(),
	KDialogBase::Ok|KDialogBase::Cancel|KDialogBase::Help,
	KDialogBase::Ok,
	parent, name)
{
//	TQHBox ( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 )
	m_widget= new KexiNameWidget(message, plainPage(), "KexiNameWidget");
	init();
}

KexiNameDialog::KexiNameDialog(const TQString& message, 
	const TQString& nameLabel, const TQString& nameText, 
	const TQString& captionLabel, const TQString& captionText, 
	TQWidget * parent, const char * name)
 : KDialogBase(KDialogBase::Plain, TQString(),
	KDialogBase::Ok|KDialogBase::Cancel,
	KDialogBase::Ok,
	parent, name)
{
	m_widget= new KexiNameWidget(message, nameLabel, nameText,
		captionLabel, captionText, plainPage(), "KexiNameWidget");
	init();
}

KexiNameDialog::~KexiNameDialog()
{
}

void KexiNameDialog::init()
{
	TQGridLayout *lyr = new TQGridLayout(plainPage(), 2, 3);
	m_icon = new TQLabel( plainPage(), "icon" );
	m_icon->setAlignment( int( AlignTop | AlignLeft ) );
	m_icon->setSizePolicy(TQSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Preferred,1,0));
	m_icon->setFixedWidth(50);
	lyr->addWidget(m_icon,0,0);

	m_widget->setSizePolicy(TQSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Preferred,1,0));
	lyr->addWidget(m_widget,0,1);
	lyr->addItem(new TQSpacerItem( 25, 10, TQSizePolicy::Expanding, TQSizePolicy::Minimum ), 0, 2);
	lyr->addItem(new TQSpacerItem( 5, 10, TQSizePolicy::Minimum, TQSizePolicy::Expanding ), 1, 1);
//	m_widget->captionLineEdit()->selectAll();
//	m_widget->captionLineEdit()->setFocus();
	connect(m_widget,TQT_SIGNAL(messageChanged()),this, TQT_SLOT(updateSize()));
	updateSize();
	enableButtonOK( true );
	slotTextChanged();
	connect(m_widget, TQT_SIGNAL(textChanged()), this, TQT_SLOT(slotTextChanged()));
}

void KexiNameDialog::updateSize()
{
//	resize( TQSize(400, 140 + (m_widget->lbl_message->isVisible()?m_widget->lbl_message->height():0) )
	resize( TQSize(400, 140 + (!m_widget->lbl_message->text().isEmpty()?m_widget->lbl_message->height():0) )
		.expandedTo(minimumSizeHint()) );
//	updateGeometry();
}

void KexiNameDialog::slotTextChanged()
{
	bool enable = true;
	if (m_widget->isNameRequired() && m_widget->nameText().isEmpty()
		|| m_widget->isCaptionRequired() && m_widget->captionText().isEmpty())
		enable = false;
	enableButtonOK( enable );
}

void KexiNameDialog::accept()
{
	if (!m_widget->checkValidity())
		return;
	KDialogBase::accept();
}

void KexiNameDialog::setDialogIcon(const TQPixmap& icon)
{
	m_icon->setPixmap(icon);
}

void KexiNameDialog::show()
{
	m_widget->captionLineEdit()->selectAll();
	m_widget->captionLineEdit()->setFocus();
	KDialogBase::show();
}

#include "kexinamedialog.moc"

