/* This file is part of the KDE project
   Copyright (C) 2004, 2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "validator.h"

using namespace KexiUtils;

Validator::Validator(TQObject * parent, const char * name)
: TQValidator(parent,name)
, m_acceptsEmptyValue(false)
{
}

Validator::~Validator()
{
}

Validator::Result Validator::check(const TQString &valueName, const TQVariant& v, 
	TQString &message, TQString &details)
{
	if (v.isNull() || v.type()==TQVariant::String && v.toString().isEmpty()) {
		if (!m_acceptsEmptyValue) {
			message = Validator::msgColumnNotEmpty().arg(valueName);
			return Error;
		}
		return Ok;
	}
	return internalCheck(valueName, v, message, details);
}

Validator::Result Validator::internalCheck(const TQString & /*valueName*/, 
	const TQVariant& /*v*/, TQString & /*message*/, TQString & /*details*/)
{
	return Error;
}

TQValidator::State Validator::validate ( TQString & , int & ) const
{
	return TQValidator::Acceptable;
}

//-----------------------------------------------------------

MultiValidator::MultiValidator(TQObject* parent, const char * name)
 : Validator(parent, name)
{
	m_ownedSubValidators.setAutoDelete(true);
}

MultiValidator::MultiValidator(TQValidator *validator, 
	TQObject * parent, const char * name)
 : Validator(parent, name)
{
	addSubvalidator(validator);
}


void MultiValidator::addSubvalidator( TQValidator* validator, bool owned )
{
	if (!validator)
		return;
	m_subValidators.append(validator);
	if (owned && !validator->parent())
		m_ownedSubValidators.append(validator);
}

TQValidator::State MultiValidator::validate( TQString & input, int & pos ) const
{
	State s;
	foreach( TQValueList<TQValidator*>::ConstIterator, it,  m_subValidators ) {
		s = (*it)->validate(input, pos);
		if (s==Intermediate || s==Invalid)
			return s;
	}
	return Acceptable;
}

void MultiValidator::fixup ( TQString & input ) const
{
	foreach( TQValueList<TQValidator*>::ConstIterator, it,  m_subValidators )
		(*it)->fixup(input);
}

Validator::Result MultiValidator::internalCheck(
	const TQString &valueName, const TQVariant& v, 
	TQString &message, TQString &details)
{
	Result r;
	bool warning = false;
	foreach( TQValueList<TQValidator*>::ConstIterator, it,  m_subValidators ) {
		if (dynamic_cast<Validator*>(*it))
			r = dynamic_cast<Validator*>(*it)->internalCheck(valueName, v, message, details);
		else
			r = Ok; //ignore
		if (r==Error)
			return Error;
		else if (r==Warning)
			warning = true;
	}
	return warning ? Warning : Ok;
}

