BEGIN TRANSACTION;
CREATE TABLE kexi__db (db_property Text(32), db_value CLOB);
INSERT INTO "kexi__db" VALUES('kexidb_major_ver', '1');
INSERT INTO "kexi__db" VALUES('kexidb_minor_ver', '2');
INSERT INTO "kexi__db" VALUES('kexiproject_major_ver', '1');
INSERT INTO "kexi__db" VALUES('kexiproject_minor_ver', '0');
CREATE TABLE kexi__fields (t_id UNSIGNED Integer, f_type UNSIGNED Byte, f_name Text(200), f_length Integer, f_precision Integer, f_constraints Integer, f_options Integer, f_default Text(200), f_order Integer, f_caption Text(200), f_help CLOB);
INSERT INTO "kexi__fields" VALUES(1, 3, 'id', 0, 0, 119, 1, NULL, 1, 'ID', NULL);
INSERT INTO "kexi__fields" VALUES(1, 3, 'age', 0, 0, 0, 1, NULL, 2, 'Age', NULL);
INSERT INTO "kexi__fields" VALUES(1, 11, 'name', 200, 0, 0, 0, NULL, 3, 'Name', NULL);
INSERT INTO "kexi__fields" VALUES(1, 11, 'surname', 200, 0, 0, 0, NULL, 4, 'Surname', NULL);
INSERT INTO "kexi__fields" VALUES(53, 11, 'a', 200, 0, 0, 200, '1', 0, NULL, NULL);
INSERT INTO "kexi__fields" VALUES(53, 11, 'b', 200, 0, 0, 200, '2', 1, NULL, NULL);
INSERT INTO "kexi__fields" VALUES(2, 3, 'id', 0, 0, 119, 1, NULL, 0, 'ID', NULL);
INSERT INTO "kexi__fields" VALUES(2, 11, 'model', 200, 0, 0, 0, NULL, 1, 'Car model', NULL);
INSERT INTO "kexi__fields" VALUES(103, 4, 'id', 0, 0, 119, 1, NULL, 0, 'Id', NULL);
INSERT INTO "kexi__fields" VALUES(103, 3, 'owner', 0, 0, 0, 0, NULL, 1, 'Owner', NULL);
INSERT INTO "kexi__fields" VALUES(103, 3, 'car', 0, 0, 0, 0, NULL, 2, 'Car', NULL);
INSERT INTO "kexi__fields" VALUES(103, 3, 'since', 0, 0, 0, 0, NULL, 3, 'Since', NULL);
CREATE TABLE kexi__objectdata (o_id UNSIGNED Integer NOT NULL, o_data CLOB, o_sub_id Text(200));
INSERT INTO "kexi__objectdata" VALUES(4, '<!DOCTYPE UI>
<UI stdsetdef="1" version="3.1" >
<kfd:customHeader version="2" />
<pixmapinproject/>
<class>TQWidget</class>
<widget class="TQWidget" >
<property name="name" >
<cstring>formularz1</cstring>
</property>
<property name="geometry" >
<rect>
<x>0</x>
<y>0</y>
<width>500</width>
<height>200</height>
</rect>
</property>
<property name="caption" >
<string>formularz1</string>
</property>
<property name="dataSource" >
<string>persons</string>
</property>
<property name="dataSourceMimeType" >
<cstring>kexi/table</cstring>
</property>
<property name="paletteBackgroundColor" >
<color>
<red>255</red>
<green>220</green>
<blue>168</blue>
</color>
</property>
<widget class="KexiDBLabel" >
<property name="name" >
<cstring>TextLabel1</cstring>
</property>
<property name="geometry" >
<rect>
<x>20</x>
<y>40</y>
<width>152</width>
<height>36</height>
</rect>
</property>
<property name="dataSource" >
<string>name</string>
</property>
<property name="font" >
<font>
<family>Verdana</family>
<pointsize>12</pointsize>
<weight>50</weight>
<bold>0</bold>
<italic>1</italic>
<underline>0</underline>
<strikeout>0</strikeout>
</font>
</property>
<property name="shadowEnabled" >
<bool>true</bool>
</property>
<property name="text" >
<string>Name</string>
</property>
<property name="alignment" >
<set>WordBreak|AlignBottom</set>
</property>
</widget>
<widget class="Line" >
<property name="name" >
<cstring>Line1</cstring>
</property>
<property name="geometry" >
<rect>
<x>20</x>
<y>80</y>
<width>450</width>
<height>11</height>
</rect>
</property>
<property name="frameShadow" >
<enum>Plain</enum>
</property>
<property name="lineWidth" >
<number>3</number>
</property>
<property name="orientation" >
<enum>Horizontal</enum>
</property>
</widget>
<widget class="KexiDBLabel" >
<property name="name" >
<cstring>TextLabel2</cstring>
</property>
<property name="geometry" >
<rect>
<x>180</x>
<y>40</y>
<width>182</width>
<height>36</height>
</rect>
</property>
<property name="dataSource" >
<string>surname</string>
</property>
<property name="font" >
<font>
<family>Verdana</family>
<pointsize>12</pointsize>
<weight>50</weight>
<bold>0</bold>
<italic>1</italic>
<underline>0</underline>
<strikeout>0</strikeout>
</font>
</property>
<property name="shadowEnabled" >
<bool>true</bool>
</property>
<property name="text" >
<string>Surname</string>
</property>
<property name="alignment" >
<set>WordBreak|AlignBottom</set>
</property>
</widget>
<widget class="KexiDBImageBox" >
<property name="name" >
<cstring>obrazek2</cstring>
</property>
<property name="geometry" >
<rect>
<x>380</x>
<y>10</y>
<width>90</width>
<height>70</height>
</rect>
</property>
<property name="alignment" >
<set>AlignTop|AlignRight</set>
</property>
<property name="storedPixmapId" >
<number>3</number>
</property>
</widget>
<widget class="KexiDBAutoField" >
<property name="name" >
<cstring>age</cstring>
</property>
<property name="geometry" >
<rect>
<x>20</x>
<y>150</y>
<width>148</width>
<height>21</height>
</rect>
</property>
<property name="dataSource" >
<string>age</string>
</property>
</widget>
<widget class="KexiDBAutoField" >
<property name="name" >
<cstring>name</cstring>
</property>
<property name="geometry" >
<rect>
<x>10</x>
<y>100</y>
<width>159</width>
<height>21</height>
</rect>
</property>
<property name="autoCaption" >
<bool>false</bool>
</property>
<property name="dataSource" >
<string>name</string>
</property>
</widget>
<widget class="KexiDBAutoField" >
<property name="name" >
<cstring>surname</cstring>
</property>
<property name="geometry" >
<rect>
<x>170</x>
<y>100</y>
<width>200</width>
<height>21</height>
</rect>
</property>
<property name="autoCaption" >
<bool>false</bool>
</property>
<property name="dataSource" >
<string>surname</string>
</property>
</widget>
</widget>
<layoutDefaults spacing="6" margin="11" />
<tabstops>
<tabstop>TextLabel1</tabstop>
<tabstop>TextLabel2</tabstop>
<tabstop>obrazek2</tabstop>
<tabstop>age</tabstop>
<tabstop>name</tabstop>
<tabstop>surname</tabstop>
</tabstops>
</UI>
', NULL);
INSERT INTO "kexi__objectdata" VALUES(65, X'3C21444F43545950452055493E0A3C5549207374647365746465663D2231222076657273696F6E3D22332E3122203E0A3C6B66643A637573746F6D4865616465722076657273696F6E3D223222202F3E0A3C7069786D6170696E70726F6A6563742F3E0A3C636C6173733E515769646765743C2F636C6173733E0A3C77696467657420636C6173733D225157696467657422203E0A3C70726F7065727479206E616D653D226E616D6522203E0A3C63737472696E673E666F726D313C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2267656F6D6574727922203E0A3C726563743E0A3C783E303C2F783E0A3C793E303C2F793E0A3C77696474683E3533303C2F77696474683E0A3C6865696768743E3232303C2F6865696768743E0A3C2F726563743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D226175746F54616253746F707322203E0A3C626F6F6C3E747275653C2F626F6F6C3E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2263617074696F6E22203E0A3C737472696E673E666F726D313C2F737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2264617461536F7572636522203E0A3C737472696E673E636172733C2F737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2264617461536F757263654D696D655479706522203E0A3C63737472696E673E6B6578692F7461626C653C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D22666F637573506F6C69637922203E0A3C656E756D3E4E6F466F6375733C2F656E756D3E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2269636F6E22202F3E0A3C70726F7065727479206E616D653D2270616C657474654261636B67726F756E64436F6C6F7222203E0A3C636F6C6F723E0A3C7265643E3230333C2F7265643E0A3C677265656E3E3233383C2F677265656E3E0A3C626C75653E3138353C2F626C75653E0A3C2F636F6C6F723E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2270616C657474654261636B67726F756E645069786D617022202F3E0A3C77696467657420636C6173733D224B65786944424C6162656C22203E0A3C70726F7065727479206E616D653D226E616D6522203E0A3C63737472696E673E546578744C6162656C313C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2267656F6D6574727922203E0A3C726563743E0A3C783E33303C2F783E0A3C793E32303C2F793E0A3C77696474683E3236363C2F77696474683E0A3C6865696768743E33343C2F6865696768743E0A3C2F726563743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2264617461536F7572636522203E0A3C737472696E673E6D6F64656C3C2F737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D22666F6E7422203E0A3C666F6E743E0A3C66616D696C793E56657264616E613C2F66616D696C793E0A3C706F696E7473697A653E31363C2F706F696E7473697A653E0A3C7765696768743E37353C2F7765696768743E0A3C626F6C643E313C2F626F6C643E0A3C6974616C69633E303C2F6974616C69633E0A3C756E6465726C696E653E303C2F756E6465726C696E653E0A3C737472696B656F75743E303C2F737472696B656F75743E0A3C2F666F6E743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2270616C657474654261636B67726F756E645069786D617022202F3E0A3C70726F7065727479206E616D653D22736861646F77456E61626C656422203E0A3C626F6F6C3E747275653C2F626F6F6C3E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D227465787422203E0A3C737472696E673E4D6F64656C3C2F737472696E673E0A3C2F70726F70657274793E0A3C2F7769646765743E0A3C77696467657420636C6173733D224B65786944424C6162656C22203E0A3C70726F7065727479206E616D653D226E616D6522203E0A3C63737472696E673E546578744C6162656C323C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2267656F6D6574727922203E0A3C726563743E0A3C783E33303C2F783E0A3C793E3131303C2F793E0A3C77696474683E37363C2F77696474683E0A3C6865696768743E32343C2F6865696768743E0A3C2F726563743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D227465787422203E0A3C737472696E673E49443C2F737472696E673E0A3C2F70726F70657274793E0A3C2F7769646765743E0A3C77696467657420636C6173733D224B65786950757368427574746F6E22203E0A3C70726F7065727479206E616D653D226E616D6522203E0A3C63737472696E673E50757368427574746F6E313C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2267656F6D6574727922203E0A3C726563743E0A3C783E3331303C2F783E0A3C793E3130303C2F793E0A3C77696474683E3133303C2F77696474683E0A3C6865696768743E34303C2F6865696768743E0A3C2F726563743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D226F6E436C69636B416374696F6E22203E0A3C737472696E673E6B616374696F6E3A77696E646F775F636C6F73653C2F737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D227465787422203E0A3C737472696E673E436C6F73652057696E646F773C2F737472696E673E0A3C2F70726F70657274793E0A3C2F7769646765743E0A3C77696467657420636C6173733D224B65786950757368427574746F6E22203E0A3C70726F7065727479206E616D653D226E616D6522203E0A3C63737472696E673E50757368427574746F6E323C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2267656F6D6574727922203E0A3C726563743E0A3C783E3331303C2F783E0A3C793E3135303C2F793E0A3C77696474683E3133333C2F77696474683E0A3C6865696768743E33373C2F6865696768743E0A3C2F726563743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D22666F637573506F6C69637922203E0A3C656E756D3E4E6F466F6375733C2F656E756D3E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D226F6E436C69636B416374696F6E22203E0A3C737472696E673E6B616374696F6E3A646174615F736176655F726F773C2F737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D227465787422203E0A3C737472696E673E53617665204368616E6765733C2F737472696E673E0A3C2F70726F70657274793E0A3C2F7769646765743E0A3C77696467657420636C6173733D224B65786944424C6162656C22203E0A3C70726F7065727479206E616D653D226E616D6522203E0A3C63737472696E673E546578744C6162656C343C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2267656F6D6574727922203E0A3C726563743E0A3C783E33303C2F783E0A3C793E3134303C2F793E0A3C77696474683E37363C2F77696474683E0A3C6865696768743E32343C2F6865696768743E0A3C2F726563743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D227465787422203E0A3C737472696E673E4D6F64656C3C2F737472696E673E0A3C2F70726F70657274793E0A3C2F7769646765743E0A3C77696467657420636C6173733D224B6578694442496D616765426F7822203E0A3C70726F7065727479206E616D653D226E616D6522203E0A3C63737472696E673E6F6272617A656B323C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2267656F6D6574727922203E0A3C726563743E0A3C783E3331303C2F783E0A3C793E31303C2F793E0A3C77696474683E3131303C2F77696474683E0A3C6865696768743E37303C2F6865696768743E0A3C2F726563743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2273746F7265645069786D6170496422203E0A3C6E756D6265723E313C2F6E756D6265723E0A3C2F70726F70657274793E0A3C2F7769646765743E0A3C77696467657420636C6173733D224B65786944424C696E654564697422203E0A3C70726F7065727479206E616D653D226E616D6522203E0A3C63737472696E673E6964456469743C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2267656F6D6574727922203E0A3C726563743E0A3C783E3131303C2F783E0A3C793E3131303C2F793E0A3C77696474683E3132303C2F77696474683E0A3C6865696768743E32303C2F6865696768743E0A3C2F726563743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2264617461536F7572636522203E0A3C737472696E673E69643C2F737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D22666F637573506F6C69637922203E0A3C656E756D3E5374726F6E67466F6375733C2F656E756D3E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D227465787422203E0A3C737472696E673E3C2F737472696E673E0A3C2F70726F70657274793E0A3C2F7769646765743E0A3C77696467657420636C6173733D224B65786944424C696E654564697422203E0A3C70726F7065727479206E616D653D226E616D6522203E0A3C63737472696E673E6D6F64656C456469743C2F63737472696E673E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2267656F6D6574727922203E0A3C726563743E0A3C783E3131303C2F783E0A3C793E3134303C2F793E0A3C77696474683E3132303C2F77696474683E0A3C6865696768743E32303C2F6865696768743E0A3C2F726563743E0A3C2F70726F70657274793E0A3C70726F7065727479206E616D653D2264617461536F7572636522203E0A3C737472696E673E6D6F64656C3C2F737472696E673E0A3C2F70726F70657274793E0A3C2F7769646765743E0A3C2F7769646765743E0A3C696E636C75646568696E74733E0A3C696E636C75646568696E743E6B70757368627574746F6E2E683C2F696E636C75646568696E743E0A3C696E636C75646568696E743E6B6C696E65656469742E683C2F696E636C75646568696E743E0A3C2F696E636C75646568696E74733E0A3C6C61796F757444656661756C74732073706163696E673D223622206D617267696E3D22313122202F3E0A3C74616273746F70733E0A3C74616273746F703E546578744C6162656C313C2F74616273746F703E0A3C74616273746F703E6F6272617A656B323C2F74616273746F703E0A3C74616273746F703E546578744C6162656C323C2F74616273746F703E0A3C74616273746F703E6964456469743C2F74616273746F703E0A3C74616273746F703E50757368427574746F6E313C2F74616273746F703E0A3C74616273746F703E546578744C6162656C343C2F74616273746F703E0A3C74616273746F703E6D6F64656C456469743C2F74616273746F703E0A3C74616273746F703E50757368427574746F6E323C2F74616273746F703E0A3C2F74616273746F70733E0A3C2F55493E0A00', NULL);
INSERT INTO "kexi__objectdata" VALUES(96, '<!DOCTYPE UI>
<UI stdsetdef="1" version="3.1" >
 <pixmapinproject/>
 <class>TQWidget</class>
 <widget class="TQWidget" >
  <property name="name" >
   <cstring>report2</cstring>
  </property>
  <property name="geometry" >
   <rect>
    <x>0</x>
    <y>0</y>
    <width>590</width>
    <height>590</height>
   </rect>
  </property>
  <property name="caption" >
   <string></string>
  </property>
  <widget class="Label" >
   <property name="name" >
    <cstring>Label1</cstring>
   </property>
   <property name="geometry" >
    <rect>
     <x>10</x>
     <y>20</y>
     <width>566</width>
     <height>134</height>
    </rect>
   </property>
   <property name="backgroundOrigin" >
    <enum>ParentOrigin</enum>
   </property>
   <property name="font" >
    <font>
     <family>Trebuchet MS</family>
     <pointsize>48</pointsize>
     <weight>75</weight>
     <bold>1</bold>
     <italic>1</italic>
     <underline>0</underline>
     <strikeout>0</strikeout>
    </font>
   </property>
   <property name="text" >
    <string>Sales Report</string>
   </property>
  </widget>
  <widget class="PicLabel" >
   <property name="name" >
    <cstring>PicLabel1</cstring>
   </property>
   <property name="geometry" >
    <rect>
     <x>420</x>
     <y>170</y>
     <width>1</width>
     <height>1</height>
    </rect>
   </property>
   <property name="backgroundMode" >
    <enum>PaletteBackground</enum>
   </property>
   <property name="backgroundOrigin" >
    <enum>ParentOrigin</enum>
   </property>
   <property name="cursor" >
    <cursor>0</cursor>
   </property>
   <property name="frameShape" >
    <enum>NoFrame</enum>
   </property>
   <property name="pixmap" >
    <pixmap>image0</pixmap>
   </property>
   <property name="scaledContents" >
    <bool>true</bool>
   </property>
  </widget>
  <widget class="KexiSubReport" >
   <property name="name" >
    <cstring>SubReport1</cstring>
   </property>
   <property name="geometry" >
    <rect>
     <x>20</x>
     <y>170</y>
     <width>330</width>
     <height>290</height>
    </rect>
   </property>
  </widget>
 </widget>
 <images>
  <image name="image0" >
   <data format="XBM.GZ" length="79" >789c534e494dcbcc4b554829cdcdad8c2fcf4c29c95030e0524611cd48cd4ccf28010a1797249664262b2467241641a592324b8aa363156c15aab914146aadb90067111b1f</data>
  </image>
 </images>
 <layoutDefaults spacing="6" margin="11" />
 <tabstops>
  <tabstop>SubReport1</tabstop>
 </tabstops>
</UI>
', NULL);
INSERT INTO "kexi__objectdata" VALUES(101, '<!DOCTYPE script>
<script language="python" ># This is Technology Preview (BETA) version of scripting
# support in Kexi. The scripting API may change in details
# in the next Kexi version.
# For more information and documentation see
# http://www.kexi-project.org/scripting/

# Saves the contents of &quot;persons&quot; table, without the &quot;id&quot; column
# to a &quot;SimpleReport54321.txt&quot; text file in the current user''s home
# directory. Totals about average, minimum, maximum age are appended.

import krosskexidb, krosskexiapp, os, codecs

keximainwindow = krosskexiapp.get(&quot;KexiAppMainWindow&quot;)
connection = keximainwindow.getConnection()
table = connection.tableSchema(&quot;persons&quot;)
if not table:
	raise(&quot;No table ''persons''&quot;)
query = table.query()

cursor = connection.executeQuerySchema(query)
if not cursor:
	raise(&quot;Query failed&quot;)

sum = 0
max = 0
min = 1000
count = 0

# Walk through all items in the table.
filename = os.path.expanduser(&quot;~&quot;)+os.sep+&quot;SimpleReport54321.txt&quot;
f = codecs.open(filename, &quot;wt&quot;, &quot;utf-8&quot;)
if not f:
	raise(&quot;Opening file failed&quot;)
f.write(&quot;%s\t%s\t%s\n-------------------------\n&quot; 
	% (query.fieldlist().field(1).caption(),
	query.fieldlist().field(2).caption(),
	query.fieldlist().field(3).caption()))
while cursor.moveNext():
	count += 1
	sum += cursor.value(1)
	if max &lt; cursor.value(1):
		max = cursor.value(1)
	if min > cursor.value(1):
		min = cursor.value(1)
	f.write( &quot;%s\t%s\t%s\n&quot; % (cursor.value(1), cursor.value(2),cursor.value(3)))

f.write( &quot;\nAverage age:\t%.2f\n&quot; % (sum / count) )
f.write( &quot;Minimum age:\t%.2f\n&quot; % min)
f.write( &quot;Maximum age:\t%.2f\n&quot; % max)
f.close()
</script>
', NULL);
INSERT INTO "kexi__objectdata" VALUES(104, 'SELECT persons.name, persons.surname, persons.age, cars.model, ownership.since FROM persons, ownership, cars WHERE cars.id = ownership.car AND persons.id = ownership.owner', 'sql');
INSERT INTO "kexi__objectdata" VALUES(104, '<query_layout><table name="persons" x="380" y="54" width="110" height="132"/><table name="ownership" x="180" y="49" width="110" height="132"/><table name="cars" x="9" y="57" width="110" height="92"/><conn mtable="cars" mfield="id" dtable="ownership" dfield="car"/><conn mtable="persons" mfield="id" dtable="ownership" dfield="owner"/></query_layout>', 'query_layout');
INSERT INTO "kexi__objectdata" VALUES(103, '<!DOCTYPE EXTENDED_TABLE_SCHEMA>
<EXTENDED_TABLE_SCHEMA version="1" >
 <field name="owner" >
  <lookup-column>
   <row-source>
    <type>table</type>
    <name>persons</name>
   </row-source>
   <bound-column>
    <number>0</number>
   </bound-column>
   <visible-column>
    <number>3</number>
   </visible-column>
  </lookup-column>
 </field>
 <field name="car" >
  <lookup-column>
   <row-source>
    <type>table</type>
    <name>cars</name>
   </row-source>
   <bound-column>
    <number>0</number>
   </bound-column>
   <visible-column>
    <number>1</number>
   </visible-column>
  </lookup-column>
 </field>
</EXTENDED_TABLE_SCHEMA>
', 'extended_schema');
INSERT INTO "kexi__objectdata" VALUES(105, '<!DOCTYPE UI>
<UI stdsetdef="1" version="3.1" >
<kfd:customHeader version="2" />
<pixmapinproject/>
<class>TQWidget</class>
<widget class="TQWidget" >
<property name="name" >
<cstring>form1</cstring>
</property>
<property name="geometry" >
<rect>
<x>0</x>
<y>0</y>
<width>514</width>
<height>611</height>
</rect>
</property>
<property name="autoTabStops" >
<bool>true</bool>
</property>
<property name="dataSource" >
<string>ownership</string>
</property>
<property name="dataSourceMimeType" >
<cstring>kexi/table</cstring>
</property>
<property name="paletteBackgroundColor" >
<color>
<red>154</red>
<green>168</green>
<blue>198</blue>
</color>
</property>
<widget class="KexiDBComboBox" >
<property name="name" >
<cstring>comboBox</cstring>
</property>
<property name="geometry" >
<rect>
<x>100</x>
<y>90</y>
<width>121</width>
<height>26</height>
</rect>
</property>
<property name="dataSource" >
<string>owner</string>
</property>
</widget>
<widget class="KexiDBComboBox" >
<property name="name" >
<cstring>comboBox2</cstring>
</property>
<property name="geometry" >
<rect>
<x>100</x>
<y>130</y>
<width>121</width>
<height>26</height>
</rect>
</property>
<property name="dataSource" >
<string>car</string>
</property>
</widget>
<widget class="KexiDBLabel" >
<property name="name" >
<cstring>label</cstring>
</property>
<property name="geometry" >
<rect>
<x>20</x>
<y>90</y>
<width>55</width>
<height>29</height>
</rect>
</property>
<property name="text" >
<string>Owner:</string>
</property>
</widget>
<widget class="KexiDBLabel" >
<property name="name" >
<cstring>label2</cstring>
</property>
<property name="geometry" >
<rect>
<x>20</x>
<y>130</y>
<width>69</width>
<height>29</height>
</rect>
</property>
<property name="text" >
<string>Car:</string>
</property>
</widget>
<widget class="KexiDBLabel" >
<property name="name" >
<cstring>label3</cstring>
</property>
<property name="geometry" >
<rect>
<x>20</x>
<y>170</y>
<width>59</width>
<height>29</height>
</rect>
</property>
<property name="text" >
<string>Since:</string>
</property>
</widget>
<widget class="KexiDBLineEdit" >
<property name="name" >
<cstring>textBox</cstring>
</property>
<property name="geometry" >
<rect>
<x>100</x>
<y>170</y>
<width>172</width>
<height>26</height>
</rect>
</property>
<property name="dataSource" >
<string>since</string>
</property>
</widget>
<widget class="KexiDBLabel" >
<property name="name" >
<cstring>TextLabel1</cstring>
</property>
<property name="geometry" >
<rect>
<x>30</x>
<y>20</y>
<width>266</width>
<height>44</height>
</rect>
</property>
<property name="dataSource" >
<string></string>
</property>
<property name="font" >
<font>
<family>Verdana</family>
<pointsize>16</pointsize>
<weight>75</weight>
<bold>1</bold>
<italic>0</italic>
<underline>0</underline>
<strikeout>0</strikeout>
</font>
</property>
<property name="paletteBackgroundPixmap" />
<property name="shadowEnabled" >
<bool>true</bool>
</property>
<property name="text" >
<string>Ownership</string>
</property>
</widget>
<widget class="KexiDBImageBox" >
<property name="name" >
<cstring>image</cstring>
</property>
<property name="geometry" >
<rect>
<x>320</x>
<y>20</y>
<width>175</width>
<height>149</height>
</rect>
</property>
<property name="storedPixmapId" >
<number>5</number>
</property>
</widget>
</widget>
<includes>
<include location="global" impldecl="in implementation">kcombobox.h</include>
<include location="global" impldecl="in implementation">klineedit.h</include>
</includes>
<layoutDefaults spacing="6" margin="11" />
<tabstops>
<tabstop>TextLabel1</tabstop>
<tabstop>image</tabstop>
<tabstop>label</tabstop>
<tabstop>comboBox</tabstop>
<tabstop>label2</tabstop>
<tabstop>comboBox2</tabstop>
<tabstop>label3</tabstop>
<tabstop>textBox</tabstop>
</tabstops>
</UI>
', NULL);
INSERT INTO "kexi__objectdata" VALUES(106, '<!DOCTYPE macros>
<macro xmlversion="1" >
  <item action="open" >
    <variable name="name" >cars</variable>
    <variable name="object" >form</variable>
  </item>
  <item action="navigate" >
    <variable name="record" >last</variable>
  </item>
</macro>
', NULL);
INSERT INTO "kexi__objectdata" VALUES(107, 'SELECT name, surname, age FROM persons WHERE persons.age > [Enter minimum person''s age] ORDER BY age', 'sql');
INSERT INTO "kexi__objectdata" VALUES(107, NULL, 'query_layout');
CREATE TABLE kexi__objects (o_id INTEGER PRIMARY KEY, o_type UNSIGNED Byte, o_name Text(200), o_caption Text(200), o_desc CLOB);
INSERT INTO "kexi__objects" VALUES(1, 1, 'persons', 'Persons in our company', NULL);
INSERT INTO "kexi__objects" VALUES(2, 1, 'cars', 'Cars', NULL);
INSERT INTO "kexi__objects" VALUES(4, 3, 'persons', 'Persons in our company', NULL);
INSERT INTO "kexi__objects" VALUES(65, 3, 'cars', 'Cars', NULL);
INSERT INTO "kexi__objects" VALUES(96, 4, 'report', 'Report', NULL);
INSERT INTO "kexi__objects" VALUES(101, 5, 'write_simple_text_report', 'Write simple text report', NULL);
INSERT INTO "kexi__objects" VALUES(103, 1, 'ownership', 'Ownership', NULL);
INSERT INTO "kexi__objects" VALUES(104, 2, 'persons_and_cars', 'Persons and cars', NULL);
INSERT INTO "kexi__objects" VALUES(105, 3, 'ownership', 'Ownership', NULL);
INSERT INTO "kexi__objects" VALUES(106, 7, 'open_cars_and_go_to_last', 'Open cars and go to the last row', NULL);
INSERT INTO "kexi__objects" VALUES(107, 2, 'persons_by_age', 'Persons by age', NULL);
CREATE TABLE kexi__parts (p_id INTEGER PRIMARY KEY, p_name Text(200), p_mime Text(200), p_url Text(200));
INSERT INTO "kexi__parts" VALUES(1, 'Tables', 'kexi/table', 'http://koffice.org/kexi/');
INSERT INTO "kexi__parts" VALUES(2, 'Queries', 'kexi/query', 'http://koffice.org/kexi/');
INSERT INTO "kexi__parts" VALUES(3, 'Formularze', 'kexi/form', 'http://koffice.org/kexi/');
INSERT INTO "kexi__parts" VALUES(4, 'Reports', 'kexi/report', 'http://www.koffice.org/kexi/');
INSERT INTO "kexi__parts" VALUES(5, 'Scripts', 'kexi/script', 'http://www.koffice.org/kexi/');
INSERT INTO "kexi__parts" VALUES(7, 'Macros', 'kexi/macro', 'http://www.koffice.org/kexi/');
CREATE TABLE kexi__querydata (q_id UNSIGNED Integer, q_sql CLOB, q_valid Boolean);
CREATE TABLE kexi__queryfields (q_id UNSIGNED Integer, f_order Integer, f_id Integer, f_tab_asterisk UNSIGNED Integer, f_alltab_asterisk Boolean);
CREATE TABLE kexi__querytables (q_id UNSIGNED Integer, t_id UNSIGNED Integer, t_order UNSIGNED Integer);
CREATE TABLE persons (id INTEGER PRIMARY KEY, age UNSIGNED Integer, name Text(200), surname Text(200));
INSERT INTO "persons" VALUES(1, 32, 'Georege', 'Foster');
INSERT INTO "persons" VALUES(2, 62, 'Joan', 'Shelley');
INSERT INTO "persons" VALUES(3, 51, 'William', 'Gates ™');
INSERT INTO "persons" VALUES(4, 45, 'John', 'Smith');
INSERT INTO "persons" VALUES(10, 58, 'Александр', 'Пушкин');
INSERT INTO "persons" VALUES(12, 79, 'Μιχαήλ', 'Στεφανόπουλος');
CREATE TABLE kexi__blobs (o_id INTEGER PRIMARY KEY, o_data BLOB, o_name Text(200), o_caption Text(200), o_mime Text(200) NOT NULL, o_folder_id Integer UNSIGNED);
INSERT INTO "kexi__blobs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blockdevice.png', 'blockdevice', 'image/png', 0);
INSERT INTO "kexi__blobs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kuser.png', 'kuser', 'image/png', 0);
INSERT INTO "kexi__blobs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folder_yellow.png', 'folder yellow', 'image/png', 0);
INSERT INTO "kexi__blobs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folder_yellow.png', 'folder yellow', 'image/png', 0);
CREATE TABLE cars (id INTEGER PRIMARY KEY, model Text(200));
INSERT INTO "cars" VALUES(1, 'Fiat');
INSERT INTO "cars" VALUES(2, 'Syrena');
INSERT INTO "cars" VALUES(3, 'Chrysler');
INSERT INTO "cars" VALUES(4, 'Volvo');
INSERT INTO "cars" VALUES(5, 'BMW');
CREATE TABLE ownership (id INTEGER PRIMARY KEY, owner Integer, car Integer, since Integer);
INSERT INTO "ownership" VALUES(1, 1, 1, 2004);
INSERT INTO "ownership" VALUES(2, 2, 2, 1982);
INSERT INTO "ownership" VALUES(3, 3, 3, 2002);
INSERT INTO "ownership" VALUES(4, 4, 4, 2005);
INSERT INTO "ownership" VALUES(5, 10, 4, 2006);
INSERT INTO "ownership" VALUES(6, 4, 1, 2003);
INSERT INTO "ownership" VALUES(7, 12, 3, 1999);
COMMIT;
