/**
 *
 * Kalle Dalheimer <kalle@kde.org>
 */

#ifndef KCHART_VIEW
#define KCHART_VIEW


#include <KoView.h>
#include "kdchart/KDChartAxisParams.h"

class TDEAction;
class TDEToggleAction;
class TQPaintEvent;

class DCOPObject;

namespace KChart
{

class KChartPart;
class kchartDataEditor;

class KChartView : public KoView
{
    TQ_OBJECT
  
public:
    KChartView( KChartPart* part, TQWidget* parent = 0, const char* name = 0 );
    ~KChartView();

    void updateGuiTypeOfChart();
    virtual DCOPObject* dcopObject();

    void config(int flag);

public slots:
    void  editData();
     void applyEdit(kchartDataEditor *ed);
    void  slotConfig();
    void  wizard();
    void  saveConfig();
    void  loadConfig();
    void  defaultConfig();

    void  pieChart();
    void  barsChart();
    void  lineChart();
    void  areasChart();
    void  hiLoChart();
    void  ringChart();
    void  polarChart();
    void  bwChart();
    void  print(KPrinter &);
    void  setupPrinter(KPrinter &);

    void  slotRepaint();
    void  slotConfigBack();
    void  slotConfigFont();
    void  slotConfigColor();
    void  slotConfigLegend();
    void  slotConfigHeaderFooterChart();
    void  slotConfigSubTypeChart();
    void  slotConfigDataFormat();

    void  slotConfigPageLayout();
    void  importData();
    void  extraCreateTemplate();

protected:
    void          paintEvent( TQPaintEvent* );

    virtual void  updateReadWrite( bool readwrite );

    virtual void  mousePressEvent ( TQMouseEvent * );
    void          updateButton();

private:
    TDEAction  *m_importData;
    TDEAction  *m_wizard;
    TDEAction  *m_edit;
    TDEAction  *m_config;
    TDEAction  *m_saveconfig;
    TDEAction  *m_loadconfig;
    TDEAction  *m_defaultconfig;
    TDEAction  *m_colorConfig;
    TDEAction  *m_fontConfig;
    TDEAction  *m_backConfig;
    TDEAction  *m_legendConfig;
    TDEAction  *m_dataFormatConfig;
    TDEAction  *m_subTypeChartConfig;
    TDEAction  *m_headerFooterConfig;
    TDEAction  *m_pageLayoutConfig;

    TDEToggleAction  *m_chartpie;
    TDEToggleAction  *m_chartareas;
    TDEToggleAction  *m_chartbars;
    TDEToggleAction  *m_chartline;
    TDEToggleAction  *m_charthilo;
    TDEToggleAction  *m_chartring;
    TDEToggleAction  *m_chartpolar;
    TDEToggleAction  *m_chartbw;

    DCOPObject  *m_dcop;

    // This is used for a workaround for a bug in the kdchart code, see #101490.
    bool m_logarithmicScale;
    void forceAxisParams(bool lineMode);
};

}  //KChart namespace

#endif
