/* This file is part of the KDE project
   Copyright (C) 2002, The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.

*/

#include <tqcursor.h>
#include <tqevent.h>

#include <tdelocale.h>

#include "vzoomtool.h"
#include <karbon_part.h>
#include <karbon_part.h>
#include <karbon_view.h>
#include <karbon_view.h>
#include <render/vpainter.h>
#include <render/vpainterfactory.h>
#include <core/vcursor.h>

VZoomTool::VZoomTool(KarbonView *view ): VTool( view, "tool_zoom_plugin" )
{
	m_plusCursor = new TQCursor( VCursor::createCursor( VCursor::ZoomPlus ) );

	registerTool( this );
}

VZoomTool::~VZoomTool()
{
	delete m_plusCursor;
}

TQString
VZoomTool::contextHelp()
{
	TQString s = i18n( "<qt><b>Zoom tool:</b><br>" );
	s += i18n( "<i>Click and drag</i> to zoom into a rectangular area.<br>" );
	s += i18n( "<i>Right click</i> to zoom out of canvas.<br>" );
	s += i18n( "<i>Pressing +/- keys</i><br>to zoom into/out of canvas." );
	return s;
}

void
VZoomTool::activate()
{
	VTool::activate();
	view()->setCursor( *m_plusCursor );
}

TQString
VZoomTool::statusText()
{
	return i18n( "Zoom Tool" );
}

void
VZoomTool::deactivate()
{
}

void
VZoomTool::draw()
{
	VPainter *painter = view()->painterFactory()->editpainter();
	painter->setRasterOp( TQt::NotROP );

	if( isDragging() )
	{
		painter->setPen( TQt::DotLine );
		painter->newPath();
		painter->moveTo( KoPoint( first().x(), first().y() ) );
		painter->lineTo( KoPoint( m_current.x(), first().y() ) );
		painter->lineTo( KoPoint( m_current.x(), m_current.y() ) );
		painter->lineTo( KoPoint( first().x(), m_current.y() ) );
		painter->lineTo( KoPoint( first().x(), first().y() ) );
		painter->strokePath();
	}
}

void
VZoomTool::mouseButtonPress()
{
	m_current = first();

	recalc();

	draw();
}

void 
VZoomTool::rightMouseButtonRelease()
{
	view()->setZoomAt( view()->zoom() * 0.75, last() );
}

void
VZoomTool::mouseButtonRelease()
{
	view()->setZoomAt( view()->zoom() * 1.5, last() );
}

void
VZoomTool::mouseDrag()
{
	draw();

	recalc();

	draw();
}

void
VZoomTool::mouseDragRelease()
{
	KoRect rect( first().x(), first().y(), last().x() - first().x(), last().y() - first().y() );
	rect = rect.normalize();
	view()->setViewportRect( rect );
}

bool
VZoomTool::keyReleased( TQt::Key key )
{
	double zoomChange = 0;
	if( key == TQt::Key_Minus )
		zoomChange = 0.75;
	else if( key == TQt::Key_Plus )
		zoomChange = 1.50;

	if( zoomChange != 0 )
	{
		view()->setZoomAt( view()->zoom() * zoomChange );
		return true;
	}
	return false;
}

void
VZoomTool::recalc()
{
	m_current = last();
}

void
VZoomTool::setup( TDEActionCollection *collection )
{
	m_action = static_cast<TDERadioAction *>(collection -> action( name() ) );

	if( m_action == 0 )
	{
		m_action = new TDERadioAction( i18n( "Zoom Tool" ), "14_zoom", TQt::SHIFT+TQt::Key_H, this, TQT_SLOT( activate() ), collection, name() );
		m_action->setToolTip( i18n( "Zoom" ) );
		m_action->setExclusiveGroup( "misc" );
		//m_ownAction = true;
	}
}

