/*
   This file is part of the KDE project
   Copyright (C) 2001, 2002, 2004 Nicolas GOUTTE <goutte@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqtextcodec.h>

#include <tdelocale.h>
#include <kcharsets.h>
#include <tdeglobal.h>
#include <kdebug.h>
#include <tdeapplication.h>
#include <kcombobox.h>
#include <tdemessagebox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqradiobutton.h>
#include <tqvbuttongroup.h>
#include <tqcheckbox.h>
#include <kurlrequester.h>

#include <ExportDialogUI.h>
#include <ExportDialog.h>

HtmlExportDialog :: HtmlExportDialog(TQWidget* parent)
    : KDialogBase(parent, 0, true, i18n("KWord's HTML Export Filter"), Ok|Cancel, No, true),
      m_dialog(new ExportDialogUI(this))
{

    kapp->restoreOverrideCursor();

    TQStringList encodingList;

    encodingList += i18n( "Descriptive encoding name", "Recommended ( %1 )" ).arg( "UTF-8" );
    encodingList += i18n( "Descriptive encoding name", "Locale ( %1 )" ).arg( TQTextCodec::codecForLocale()->name() );
    encodingList += TDEGlobal::charsets()->descriptiveEncodingNames();

    m_dialog->comboBoxEncoding->insertStringList( encodingList );

    m_dialog->KURL_ExternalCSS->setMode( KFile::ExistingOnly );

     connect(m_dialog->radioModeEnhanced, TQT_SIGNAL( toggled( bool ) ),
             TQT_SLOT( setCSSEnabled( bool ) ) );
     connect(m_dialog->checkExternalCSS, TQT_SIGNAL( toggled( bool ) ),
             m_dialog->KURL_ExternalCSS, TQT_SLOT( setEnabled( bool ) ) );

    setMainWidget(m_dialog);
}

HtmlExportDialog :: ~HtmlExportDialog(void)
{
    kapp->setOverrideCursor(TQt::waitCursor);
}

void HtmlExportDialog::setCSSEnabled( bool b )
{
    m_dialog->checkExternalCSS->setEnabled( b );
    m_dialog->KURL_ExternalCSS->setEnabled( b && m_dialog->checkExternalCSS->isChecked() );
}

bool HtmlExportDialog::isXHtml(void) const
{
    if(m_dialog->radioDocType1==m_dialog->buttonGroup1->selected())
        return false;
    else if(m_dialog->radioDocType2==m_dialog->buttonGroup1->selected())
        return true;
    return true;
}

TQTextCodec* HtmlExportDialog::getCodec(void) const
{
    const TQString strCodec( TDEGlobal::charsets()->encodingForName( m_dialog->comboBoxEncoding->currentText() ) );
    kdDebug(30503) << "Encoding: " << strCodec << endl;

    bool ok = false;
    TQTextCodec* codec = TQTextCodec::codecForName( strCodec.utf8() );

    // If TQTextCodec has not found a valid encoding, so try with KCharsets.
    if ( codec )
    {
        ok = true;
    }
    else
    {
        codec = TDEGlobal::charsets()->codecForName( strCodec, ok );
    }

    // Still nothing?
    if ( !codec || !ok )
    {
        // Default: UTF-8
        kdWarning(30503) << "Cannot find encoding:" << strCodec << endl;
        // ### TODO: what parent to use?
        KMessageBox::error( 0, i18n("Cannot find encoding: %1").arg( strCodec ) );
        return 0;
    }

    return codec;
}

HtmlExportDialog::Mode HtmlExportDialog::getMode(void) const
{
    if( m_dialog->radioModeEnhanced->isChecked() )
    {
      if( m_dialog->checkExternalCSS->isChecked() )
        {
            return CustomCSS;
        }
        else
        {
            return DefaultCSS;
        }
    }
    else if ( m_dialog->radioModeBasic->isChecked() )
    {
        return Basic;
    }
    else if ( m_dialog->radioModeLight->isChecked() )
    {
        return Light;
    }
    return DefaultCSS;//Our default
}

TQString HtmlExportDialog::cssURL(void) const
{
  return m_dialog->KURL_ExternalCSS->url();
}

#include <ExportDialog.moc>
