/*
 *  Copyright (c) 1999 Matthias Elter  <me@kde.org>
 *  Copyright (c) 2004 Adrian Page <adrian@pagenet.plus.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.g
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kis_canvas.h"
#include "kis_canvas_painter.h"
#include "kis_qpaintdevice_canvas.h"
#include "kis_qpaintdevice_canvas_painter.h"
#include <kdebug.h>

KisTQPaintDeviceCanvasWidget::KisTQPaintDeviceCanvasWidget(TQWidget *parent, const char *name)
    : TQWidget(parent, name)
{
}

KisTQPaintDeviceCanvasWidget::~KisTQPaintDeviceCanvasWidget()
{
}

void KisTQPaintDeviceCanvasWidget::paintEvent(TQPaintEvent *e)
{
    widgetGotPaintEvent(e);
}

void KisTQPaintDeviceCanvasWidget::mousePressEvent(TQMouseEvent *e)
{
    widgetGotMousePressEvent(e);
}

void KisTQPaintDeviceCanvasWidget::mouseReleaseEvent(TQMouseEvent *e)
{
    widgetGotMouseReleaseEvent(e);
}

void KisTQPaintDeviceCanvasWidget::mouseDoubleClickEvent(TQMouseEvent *e)
{
    widgetGotMouseDoubleClickEvent(e);
}

void KisTQPaintDeviceCanvasWidget::mouseMoveEvent(TQMouseEvent *e)
{
    widgetGotMouseMoveEvent(e);
}

void KisTQPaintDeviceCanvasWidget::tabletEvent(TQTabletEvent *e)
{
    widgetGotTabletEvent(e);
}

void KisTQPaintDeviceCanvasWidget::enterEvent(TQEvent *e)
{
    widgetGotEnterEvent(e);
}

void KisTQPaintDeviceCanvasWidget::leaveEvent(TQEvent *e)
{
    widgetGotLeaveEvent(e);
}

void KisTQPaintDeviceCanvasWidget::wheelEvent(TQWheelEvent *e)
{
    widgetGotWheelEvent(e);
}

void KisTQPaintDeviceCanvasWidget::keyPressEvent(TQKeyEvent *e)
{
    widgetGotKeyPressEvent(e);
}

void KisTQPaintDeviceCanvasWidget::keyReleaseEvent(TQKeyEvent *e)
{
    widgetGotKeyReleaseEvent(e);
}

void KisTQPaintDeviceCanvasWidget::dragEnterEvent(TQDragEnterEvent *e)
{
    widgetGotDragEnterEvent(e);
}

void KisTQPaintDeviceCanvasWidget::dropEvent(TQDropEvent *e)
{
    widgetGotDropEvent(e);
}

#ifdef Q_WS_X11

bool KisTQPaintDeviceCanvasWidget::x11Event(XEvent *event)
{
    return KisCanvasWidget::x11Event(event, x11Display(), winId(), mapToGlobal(TQPoint(0, 0)));
}

#endif // Q_WS_X11

KisCanvasWidgetPainter *KisTQPaintDeviceCanvasWidget::createPainter()
{
    return new KisTQPaintDeviceCanvasPainter(TQT_TQPAINTDEVICE(this));
}

#if defined(EXTENDED_X11_TABLET_SUPPORT)
void KisTQPaintDeviceCanvasWidget::selectTabletDeviceEvents()
{
    KisCanvasWidget::selectTabletDeviceEvents(this);
}
#endif

