/*
 *  Copyright (c) 2004 Adrian Page <adrian@pagenet.plus.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tdelocale.h>
#include <koIconChooser.h>

#include "kis_double_widget.h"
#include "kis_brush_chooser.h"
#include "kis_global.h"
#include "kis_icon_item.h"
#include "kis_brush.h"

KisBrushChooser::KisBrushChooser(TQWidget *parent, const char *name)
    : super(parent, name)
{
    m_lbSpacing = new TQLabel(i18n("Spacing:"), this);
    m_slSpacing = new KisDoubleWidget(0.0, 10, this, "double_widget");
    m_slSpacing->setTickmarks(TQSlider::Below);
    m_slSpacing->setTickInterval(1);
    TQObject::connect(m_slSpacing, TQT_SIGNAL(valueChanged(double)), this, TQT_SLOT(slotSetItemSpacing(double)));

    m_chkColorMask = new TQCheckBox(i18n("Use color as mask"), this);
    TQObject::connect(m_chkColorMask, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(slotSetItemUseColorAsMask(bool)));

    m_lbName = new TQLabel(this);

    TQVBoxLayout *mainLayout = new TQVBoxLayout(this, 2, -1, "main layout");

    mainLayout->addWidget(m_lbName);
    mainLayout->addWidget(chooserWidget(), 10);

    TQGridLayout *spacingLayout = new TQGridLayout( 2, 2);

    mainLayout->addLayout(spacingLayout, 1);

    spacingLayout->addWidget(m_lbSpacing, 0, 0);
    spacingLayout->addWidget(m_slSpacing, 0, 1);

    spacingLayout->addMultiCellWidget(m_chkColorMask, 1, 1, 0, 1);
}

KisBrushChooser::~KisBrushChooser()
{
}

void KisBrushChooser::slotSetItemSpacing(double spacingValue)
{
    KisIconItem *item = static_cast<KisIconItem *>(currentItem());

    if (item) {
        KisBrush *brush = static_cast<KisBrush *>(item->resource());
        brush->setSpacing(spacingValue);
    }
}

void KisBrushChooser::slotSetItemUseColorAsMask(bool useColorAsMask)
{
    KisIconItem *item = static_cast<KisIconItem *>(currentItem());

    if (item) {
        KisBrush *brush = static_cast<KisBrush *>(item->resource());
        brush->setUseColorAsMask(useColorAsMask);
        item->updatePixmaps();
        emit selected(currentItem());
    }
}

void KisBrushChooser::update(KoIconItem *item)
{
    KisIconItem *kisItem = static_cast<KisIconItem *>(item);

    if (kisItem) {
        KisBrush *brush = static_cast<KisBrush *>(kisItem->resource());

        TQString text = TQString("%1 (%2 x %3)").arg(brush->name()).arg(brush->width()).arg(brush->height());

        m_lbName->setText(text);
        m_slSpacing->setValue(brush->spacing());
        m_chkColorMask->setChecked(brush->useColorAsMask());
        m_chkColorMask->setEnabled(brush->hasColor());
    }
}

#include "kis_brush_chooser.moc"

