/*
 * This file is part of Chalk
 *
 * Copyright (c) 2006 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kis_wdg_unsharp.h"

#include <tqlayout.h>
#include <tqtoolbutton.h>

#include <kcombobox.h>
#include <knuminput.h>

#include <kis_filter.h>

#include "wdgunsharp.h"

KisWdgUnsharp::KisWdgUnsharp( KisFilter* , TQWidget * parent, const char * name) : KisFilterConfigWidget ( parent, name )
{
    TQGridLayout *widgetLayout = new TQGridLayout(this, 1, 1);
    m_widget = new WdgUnsharp(this);
    widgetLayout -> addWidget(m_widget,0,0);

    connect( widget()->intHalfSize, TQT_SIGNAL( valueChanged(int)), TQT_SIGNAL(sigPleaseUpdatePreview()));
    connect( widget()->doubleAmount, TQT_SIGNAL( valueChanged(double)), TQT_SIGNAL(sigPleaseUpdatePreview()));
    connect( widget()->intThreshold, TQT_SIGNAL( valueChanged(int)), TQT_SIGNAL(sigPleaseUpdatePreview()));
}

void KisWdgUnsharp::setConfiguration(KisFilterConfiguration* config)
{
    TQVariant value;
    widget()->intHalfSize->setValue( (config->getProperty("halfSize", value)) ? value.toUInt() : 4 );
    widget()->doubleAmount->setValue( (config->getProperty("amount", value)) ? value.toDouble() : 0.1 );
    widget()->intThreshold->setValue( (config->getProperty("threshold", value)) ? value.toUInt() : 20 );
}

#include "kis_wdg_unsharp.moc"
