/*
	Jason Katz-Brown
	jason@katzbrown.com

	Reverse Polish Notation calculator for KDE.
*/

/*
	Licensed under the BSD License.
*/

#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>

#include "mathemagics.h"

static const char *description =
	I18N_NOOP("A Reverse Polish Notation scientific calculator");
	
	
static TDECmdLineOptions options[] =
{
	{ 0, 0, 0 }
};

int main(int argc, char *argv[])
{
	TDEAboutData aboutData( "mathemagics", I18N_NOOP("Mathemagics"), "1.1", description, TDEAboutData::License_BSD, "(c) 2002-2004, Jason Katz-Brown", 0, "http://katzbrown.com/mathemagics/", "jason@katzbrown.com");
	aboutData.addAuthor("Jason Katz-Brown", I18N_NOOP("Main author"), "jason@katzbrown.com");

	TDECmdLineArgs::init(argc, argv, &aboutData);
	TDECmdLineArgs::addCmdLineOptions(options);

	TDEApplication a;
	Mathemagics *mathemagics = new Mathemagics(0, "Mathemagics", TQt::WStyle_ContextHelp);
	a.setMainWidget(mathemagics);
	mathemagics->show();
	return a.exec();
}
