/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN includes
#include "newprofiledialog.h"
#include <kcombobox.h>
#include <klineedit.h>
#include <tqcheckbox.h>
#include <kurlrequester.h>
#include <tdemessagebox.h>
#include <tqlistbox.h>
#include <klineedit.h>
#include <klineeditdlg.h>
#include <tdelocale.h>
#include <knuminput.h>
#include <tqobject.h>
#include <ktextedit.h>

#include <tqlabel.h>
#include "utils.h"


#include "networkinterface.h"
#include "importcertificatedialog.h"
#include "importprofiledialog.h"
#include "vpnaccountdata.h"

//END includes

NewProfileDialog::NewProfileDialog( TQApplication *app,TQWidget *parent, const TQString& caption, KVpncConfig *GlobalConfig)
		: KDialogBase( parent, "New_profile", true, caption,
		               KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	this->GlobalConfig = GlobalConfig;

	main = new NewProfileDialogbase(this);
	setMainWidget(main);
	main->setMinimumSize(main->sizeHint());

	connect( main->ConnectionTypeComboBox, TQT_SIGNAL( activated( const TQString& ) ), this, TQT_SLOT( connectiontypeChanged( const TQString& ) ) );
	connect( main->AuthTypeComboBox , TQT_SIGNAL( activated( const TQString& ) ), this, TQT_SLOT( authTypeChanged( const TQString& ) ) );
	//	connect( main->buttonCancel , TQT_SIGNAL( clicked () ), this, TQT_SLOT( reject() ) );
	connect( main->ImportCertificatePushButton, TQT_SIGNAL( clicked () ), this, TQT_SLOT( importCertificate() ) );
	connect( main->AdvancedSettingsPushButton, TQT_SIGNAL( clicked () ), this, TQT_SLOT( advancedSettingsClicked() ) );
	connect( main->ImportPcfProfilePushButton , TQT_SIGNAL( clicked () ), this, TQT_SLOT( importPcfFileClicked() ) );
	connect( main->GroupPasswordEdit, TQT_SIGNAL( textChanged(const TQString&) ), this, TQT_SLOT( groupPasswordContentChanged() ) );
	connect( main->PasswordEdit, TQT_SIGNAL( textChanged(const TQString&) ), this, TQT_SLOT( passwordContentChanged() ) );
	newProfileCreated = FALSE;
	Name = "";

	// currently static for new profile
	VpnAccountData::ConnectionType ConnType = VpnAccountData::ConnectionType(VpnAccountData::other);
	Port = 500;
	Gateway = "";
	ID = "";
	Username = "";
	UserPassword = "";
	PreSharedKey = "";
	ApplicationVersion = "";
	NtDomainName = "";
	PerfectForwardSecrecy = "";
	IkeGroup = "";
	Description ="";
	useApplicationVersion = false;
	useGlobalIpsecSecret = false;
	useIkeGroup = false;
	useLocalPort = false;
	useNtDomainName = false;
	useSingleDes = false;
	useAdvancedSettings = false;
	usePerfectSecrecy = false;
	saveUserPassword = false;
	savePsk = false;
	useUdp=false;
	useUdpPort=false;
	useDnsServer=false;
	DnsServer="";
	useGetDnsFromPeer=true;
	refuse40BitEncryption=true;
	refuse128BitEncryption=false;
	allowStatefulMode=false;
	requireMppe=true;
	refuseEap=false;
	useNoBsdComp=true;
	useNoDeflate=true;
	savePsk=false;


	profileData = new VpnAccountData( ConnType, Name );
	profileData->setGateway ( Gateway );
	profileData->setID( ID );
	profileData->setPreSharedKey( PreSharedKey);
	profileData->setSavePsk( savePsk );
	profileData->setUserName( Username );
	profileData->setUserPassword( UserPassword );
	profileData->setSaveUserPassword( saveUserPassword );
	profileData->setSavePsk(  savePsk );
	profileData->setApplicationVersion( ApplicationVersion );
	profileData->setUseLocalPort( useLocalPort );
	profileData->setLocalPort( Port );
	profileData->setUseSingleDes ( useSingleDes );
	profileData->setPerfectForwardSecrety ( PerfectForwardSecrecy );
	profileData->setIkeGroup( IkeGroup );
	profileData->setUseGlobalIpsecSecret (useGlobalIpsecSecret );
	profileData->setUseIkeGroup ( useIkeGroup );
	profileData->setNtDomainName (NtDomainName );
	profileData->setUseAdvancedSettings ( useAdvancedSettings );
	profileData->setUsePerfectForwardSecrety (usePerfectSecrecy );




	NetworkInterface iface(GlobalConfig,app);
	TQStringList list = iface.getAllNetworkInterfaces();
	main->NetworkDeviceComboBox->insertItem( "default" );
	for ( TQStringList::Iterator it = list.begin(); it != list.end(); ++it )
	{
		main->NetworkDeviceComboBox->insertItem( TQString( *it ) );
	}
	main->NetworkDeviceComboBox->setEnabled( TRUE );
	main->NetworkDeviceComboBox->setCurrentText( "default" );

	main->certpathURLRequester->setURL( "/etc/racoon/certs" );
	main->certpathURLRequester->setMode( 2 ); // directory

	main->ConnectionTypeComboBox->insertItem( i18n( "Cisco (vpnc)" ) );
	main->ConnectionTypeComboBox->insertItem( i18n( "IPSec (racoon)" ) );
	main->ConnectionTypeComboBox->insertItem( i18n( "IPSec (FreeS/WAN)" ) );
	main->ConnectionTypeComboBox->insertItem( i18n( "PPTP" ) );
	main->ConnectionTypeComboBox->insertItem( i18n( "OpenVPN" ) );
	main->AuthTypeComboBox->setCurrentItem(1); // cisco

	main->RemoteNetMaskComboBox->setCurrentText("24");

	authTypeChanged( "" );
	connectiontypeChanged( "" );
}

NewProfileDialog::~NewProfileDialog()
{}

void NewProfileDialog::accept()
{
	bool canSave = TRUE;
	if ( main->ConnectionTypeComboBox->currentItem() == 0 ) {
		profileData->setConnectionType( VpnAccountData::cisco );
		UdpPort=10000;
}
	else if ( main->ConnectionTypeComboBox->currentItem() == 1 )
	{
		profileData->setConnectionType( VpnAccountData::racoon );

		if (main->AuthTypeComboBox->currentItem() == 0)
			profileData->setAuthType( VpnAccountData::cert );
		else
			profileData->setAuthType( VpnAccountData::psk );

		profileData->setX509Certificate( main->x509certURLRequester->url() );
		profileData->setCertPath( main->certpathURLRequester->url() );

		UdpPort=4500;
	}
	else if ( main->ConnectionTypeComboBox->currentItem() == 2 )
	{
		profileData->setConnectionType( VpnAccountData::freeswan );
		UdpPort=4500;
	}
	else if ( main->ConnectionTypeComboBox->currentItem() == 3 )
	{
		profileData->setConnectionType( VpnAccountData::pptp );
	}
	else if ( main->ConnectionTypeComboBox->currentItem() == 4 )
	{
		profileData->setConnectionType( VpnAccountData::openvpn );
	}
	else
		profileData->setConnectionType( VpnAccountData::other );

	bool validAddr = TRUE;

	if ( profileData->getConnectionType() != VpnAccountData::cisco && profileData->getConnectionType() != VpnAccountData::openvpn )
	{
		if ( main->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
		{
			KMessageBox::error ( this, i18n( "No IP address for remote network entered!" ), i18n( "No IP Address" ) );
			GlobalConfig->appendLogEntry(  i18n( "No IP address for remote network entered!" ),GlobalConfig->error);
			validAddr = canSave = FALSE;
		}
		else
		{
			if (!Utils(GlobalConfig).isValidIPv4Address(main->RemoteNetAddrLineEdit->text()))
			{

				KMessageBox::error ( this, i18n( "IP address of remote network is not valid!" ), i18n( "Invalid IP Address" ) );
				GlobalConfig->appendLogEntry( i18n( "IP address of remote network not valid!" ) ,GlobalConfig->error);

				validAddr = canSave = FALSE;
			}
			if ( validAddr )
			{
				profileData->setRemoteNetAddr( main->RemoteNetAddrLineEdit->text());
				profileData->setRemoteNetMask( main->RemoteNetMaskComboBox->currentText() );
			}

		}
	}

	// 	profileData->setSavePsk( main->CheckGroupPass->isChecked() );
	// 	profileData->setSaveUserPassword( main->CheckUserPass->isChecked () );
	profileData->setSavePsk( !main->PSKLineEdit->text().isEmpty() );
	profileData->setSaveUserPassword( !main->PasswordEdit->text().isEmpty() );
	profileData->setID( main->IDLineEdit->text() );

	profileData->setDescription( main->DescriptionLineEdit->text() );

	profileData->setUserName( main->UsernameLineEdit->text () );

	if ( main->CheckUserPass->isChecked ())
	{
		profileData->setUserPassword( main->PasswordEdit->text ( ) );
		profileData->setSaveUserPassword(true);
	}

	profileData->setGateway( main->gatewayLineEdit->text() );


	if ( main->CheckGroupPass->isChecked())
	{
		if (!profileData->getConnectionType() == VpnAccountData::cisco)
			profileData->setPreSharedKey( main->PSKLineEdit->text() );
		else
			profileData->setPreSharedKey( main->GroupPasswordEdit->text() );
		profileData->setSavePsk(true);
	}

	profileData->setX509Certificate( main->x509certURLRequester->url() );
	profileData->setCertPath( main->certpathURLRequester->url() );
	profileData->setNetworkDevice( main->NetworkDeviceComboBox->currentText() );
	if (main->AuthTypeComboBox->currentItem() == 0)
		profileData->setAuthType( VpnAccountData::cert );
	else
		profileData->setAuthType( VpnAccountData::psk );

	if ( canSave )
	{

		bool nameOk = TRUE;
		Name = main->ProfileLineEdit->text();

		if (Name.contains(' '))
		{
			KMessageBox::error ( this, i18n( "Profile name can not contain spaces!" ), i18n( "Spaces Not Allowed" ) );
			GlobalConfig->appendLogEntry( i18n( "Profile name can not contain spaces!" ) ,GlobalConfig->error);

			nameOk = FALSE;
		}

		if (Name.isEmpty())
		{
			KMessageBox::error ( this, i18n( "Profile name can not be empty!" ), i18n( "No Name Entered" ) );
			GlobalConfig->appendLogEntry( i18n( "Profile name can not be empty!" ) ,GlobalConfig->error);

			nameOk = FALSE;
		}

		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == Name )
			{
				KMessageBox::error ( this, i18n( "Profile name already exists!" ), i18n( "Name Already Exists" ) );
				GlobalConfig->appendLogEntry(i18n( "Profile name already exists!" ) ,GlobalConfig->error);

				nameOk = FALSE;
				break;
			}
		}

		if ( nameOk )
		{
			profileData->setName(Name);
			GlobalConfig->AccountList->append( profileData );
			newProfileCreated = TRUE;
			TQDialog::accept();
		}

	}
}

void NewProfileDialog::importCertificate()
{
	//FIXME make dynamiclly
	ImportCertificateDialog importdlg(  this, i18n("Import certificate...").ascii(), GlobalConfig);
	//dlg.resize(dlg.height(),600);
	//int result =
	importdlg.exec();
}


void NewProfileDialog::connectiontypeChanged( const TQString& )
{

	// First we should set a type
	//buttonOk->setEnabled( FALSE );
	main->AdvancedSettingsPushButton->setEnabled( FALSE );

	int item = main->ConnectionTypeComboBox->currentItem();

	if ( item == VpnAccountData::ConnectionType(VpnAccountData::cisco) )
	{


		GlobalConfig->appendLogEntry( i18n("New type: %1").arg("cisco"),GlobalConfig->debug );

		profileData->setConnectionType( VpnAccountData::cisco );

		main->CheckGroupPass->setEnabled( TRUE );
		main->CheckUserPass->setEnabled( TRUE );

		main->IDLineEdit->setEnabled( TRUE );
		main->LabelID->setEnabled( TRUE );

		main->UsernameLineEdit->setEnabled( TRUE );
		main->LabelUsername->setEnabled( TRUE );

		main->PasswordEdit->setEnabled( TRUE );
		main->LabelPassword->setEnabled( TRUE );

		main->AdvancedSettingsPushButton->setEnabled( TRUE );

		main->x509certURLRequester->setEnabled( FALSE );
		main->LabelCertificate->setEnabled( FALSE );

		main->certpathURLRequester->setEnabled( FALSE );
		main->LabelCertificatePath->setEnabled( FALSE );

		main->NetworkDeviceComboBox->setEnabled( FALSE );
		main->LabelNetworkDevice->setEnabled( FALSE );
		main->AuthTypeComboBox->setEnabled( FALSE );
		main->LabelAuthType->setEnabled( FALSE );

		main->PSKLineEdit->setEnabled( FALSE );
		main->LabelPsk->setEnabled( FALSE );

		//buttonCancel->setEnabled( TRUE );
		//buttonOk->setEnabled( TRUE );

		main->RemoteNetAddrLineEdit->setEnabled( FALSE );
		main->LabelRemoteNetwork->setEnabled( FALSE );

		main->RemoteNetMaskComboBox->setEnabled( FALSE );

	} // vpnc

	else if ( item == VpnAccountData::ConnectionType(VpnAccountData::racoon) )
	{


		GlobalConfig->appendLogEntry( i18n("New type: %1").arg("racoon"),GlobalConfig->debug );
		//     KURLRequester* main->x509certURLRequester;
		//     KComboBox* main->AuthTypeComboBox;
		//     KPushButton* ImportCertificatePushButton;
		//     KLineEdit* main->PSKLineEdit;

		profileData->setConnectionType( VpnAccountData::racoon );

		main->x509certURLRequester->setEnabled( TRUE );
		main->LabelCertificate->setEnabled( TRUE );

		main->certpathURLRequester->setEnabled( TRUE );
		main->LabelCertificatePath->setEnabled( TRUE );

		main->NetworkDeviceComboBox->setEnabled ( TRUE );
		main->LabelNetworkDevice->setEnabled( TRUE );

		main->AuthTypeComboBox->setEnabled( TRUE );
		main->LabelAuthType->setEnabled( TRUE );

		main->PSKLineEdit->setEnabled( TRUE );
		main->LabelPsk->setEnabled( TRUE );

		main->RemoteNetAddrLineEdit->setEnabled( TRUE );
		main->LabelRemoteNetwork->setEnabled( TRUE );

		main->RemoteNetMaskComboBox->setEnabled( TRUE );

		main->PasswordEdit->setEnabled( FALSE );
		main->LabelPassword->setEnabled( FALSE );

		main->CheckGroupPass->setEnabled( FALSE );
		main->CheckUserPass->setEnabled( FALSE );

		main->IDLineEdit->setEnabled( FALSE );
		main->LabelID->setEnabled( FALSE );

		main->UsernameLineEdit->setEnabled( FALSE );
		main->LabelUsername->setEnabled( FALSE );

		main->GroupPasswordEdit->setEnabled( FALSE );
		main->LabelGroupPassword->setEnabled( FALSE );

		//buttonCancel->setEnabled( TRUE );
		//buttonOk->setEnabled( TRUE );
		main->AdvancedSettingsPushButton->setEnabled( TRUE );
	} // racoon

	else if ( item == VpnAccountData::ConnectionType(VpnAccountData::freeswan) )
	{


		GlobalConfig->appendLogEntry( i18n("New type: %1").arg("freeswan"), GlobalConfig->debug );
		//     KURLRequester* main->x509certURLRequester;
		//     KComboBox* main->AuthTypeComboBox;
		//     KPushButton* ImportCertificatePushButton;
		//     KLineEdit* main->PSKLineEdit;

		profileData->setConnectionType( VpnAccountData::freeswan );

		main->x509certURLRequester->setEnabled( TRUE );
		main->LabelCertificate->setEnabled( TRUE );

		main->certpathURLRequester->setEnabled( TRUE );
		main->LabelCertificatePath->setEnabled( TRUE );

		main->NetworkDeviceComboBox->setEnabled ( TRUE );
		main->LabelNetworkDevice->setEnabled( TRUE );

		main->AuthTypeComboBox->setEnabled( TRUE );
		main->LabelAuthType->setEnabled( TRUE );

		main->PSKLineEdit->setEnabled( TRUE );
		main->LabelPsk->setEnabled( TRUE );

		main->RemoteNetAddrLineEdit->setEnabled( TRUE );
		main->LabelRemoteNetwork->setEnabled( TRUE );

		main->RemoteNetMaskComboBox->setEnabled( TRUE );

		main->CheckGroupPass->setEnabled( FALSE );
		main->CheckUserPass->setEnabled( FALSE );

		main->IDLineEdit->setEnabled( FALSE );
		main->LabelID->setEnabled( FALSE );

		main->PasswordEdit->setEnabled( FALSE );
		main->LabelPassword->setEnabled( FALSE );

		main->UsernameLineEdit->setEnabled( FALSE );
		main->LabelUsername->setEnabled( FALSE );

		main->GroupPasswordEdit->setEnabled( FALSE );
		main->LabelGroupPassword->setEnabled( FALSE );

		//		buttonCancel->setEnabled( TRUE );
		//		buttonOk->setEnabled( TRUE );
		main->AdvancedSettingsPushButton->setEnabled( TRUE );
	} // freeswan

	else if ( item == VpnAccountData::ConnectionType(VpnAccountData::pptp) )
	{


		GlobalConfig->appendLogEntry( i18n("New type: %1").arg("pptp"),GlobalConfig->debug );
		//     KURLRequester* main->x509certURLRequester;
		//     KComboBox* main->AuthTypeComboBox;
		//     KPushButton* ImportCertificatePushButton;
		//     KLineEdit* main->PSKLineEdit;

		profileData->setConnectionType( VpnAccountData::pptp );

		main->x509certURLRequester->setEnabled( FALSE );
		main->LabelCertificate->setEnabled( FALSE );

		main->certpathURLRequester->setEnabled( FALSE );
		main->LabelCertificatePath->setEnabled( FALSE );

		main->NetworkDeviceComboBox->setEnabled ( FALSE );
		main->LabelNetworkDevice->setEnabled( FALSE );

		main->AuthTypeComboBox->setEnabled( FALSE );
		main->LabelAuthType->setEnabled( FALSE );

		main->PSKLineEdit->setEnabled( FALSE );
		main->LabelPsk->setEnabled( FALSE );

		main->RemoteNetAddrLineEdit->setEnabled( TRUE );
		main->LabelRemoteNetwork->setEnabled( TRUE );

		main->RemoteNetMaskComboBox->setEnabled( TRUE );

		main->CheckGroupPass->setEnabled( FALSE );
		main->CheckUserPass->setEnabled( TRUE );

		main->IDLineEdit->setEnabled( FALSE );
		main->LabelID->setEnabled( FALSE );

		main->PasswordEdit->setEnabled( TRUE );
		main->LabelPassword->setEnabled( TRUE );

		main->UsernameLineEdit->setEnabled( TRUE );
		main->LabelUsername->setEnabled( TRUE );

		main->GroupPasswordEdit->setEnabled( FALSE );
		main->LabelGroupPassword->setEnabled( FALSE );

		//buttonCancel->setEnabled( TRUE );
		//buttonOk->setEnabled( TRUE );
		main->AdvancedSettingsPushButton->setEnabled( TRUE );
	} // pptp
	else if ( item == VpnAccountData::ConnectionType(VpnAccountData::openvpn) )
	{
		if (GlobalConfig->KvpncDebugLevel > 0)
			GlobalConfig->appendLogEntry( i18n("New type: %1").arg("openvpn"),GlobalConfig->debug );
		//     KURLRequester* main->x509certURLRequester;
		//     KComboBox* main->AuthTypeComboBox;
		//     KPushButton* ImportCertificatePushButton;
		//     KLineEdit* main->PSKLineEdit;

		profileData->setConnectionType( VpnAccountData::openvpn );

		main->x509certURLRequester->setEnabled( TRUE );
		main->LabelCertificate->setEnabled( TRUE );

		main->certpathURLRequester->setEnabled( TRUE );
		main->LabelCertificatePath->setEnabled( TRUE );

		main->NetworkDeviceComboBox->setEnabled ( TRUE );
		main->LabelNetworkDevice->setEnabled( TRUE );

		main->AuthTypeComboBox->setEnabled( TRUE );
		main->LabelAuthType->setEnabled( TRUE );

		main->PSKLineEdit->setEnabled( TRUE );
		main->LabelPsk->setEnabled( TRUE );

		main->RemoteNetAddrLineEdit->setEnabled( FALSE );
		main->LabelRemoteNetwork->setEnabled( FALSE );

		main->RemoteNetMaskComboBox->setEnabled( TRUE );

		main->PasswordEdit->setEnabled( FALSE );
		main->LabelPassword->setEnabled( FALSE );

		main->CheckGroupPass->setEnabled( FALSE );
		main->CheckUserPass->setEnabled( FALSE );

		main->IDLineEdit->setEnabled( FALSE );
		main->LabelID->setEnabled( FALSE );


		main->UsernameLineEdit->setEnabled( FALSE );
		main->LabelUsername->setEnabled( FALSE );

		main->GroupPasswordEdit->setEnabled( FALSE );
		main->LabelGroupPassword->setEnabled( FALSE );

		//buttonCancel->setEnabled( TRUE );
		//buttonOk->setEnabled( TRUE );
		main->AdvancedSettingsPushButton->setEnabled( TRUE );
	} // openvpn

	// other
	else
	{

		if (GlobalConfig->KvpncDebugLevel > 0)
			GlobalConfig->appendLogEntry( "new type: other",GlobalConfig->debug );
		// 		main->x509certURLRequester->setEnabled( FALSE );
		// 		main->AuthTypeComboBox->setEnabled( FALSE );
		// 		main->PSKLineEdit->setEnabled( FALSE );
		//
		// 		main->CheckGroupPass->setEnabled( FALSE );
		// 		main->CheckUserPass->setEnabled( FALSE );
		// 		main->IDLineEdit->setEnabled( FALSE );
		// 		main->UsernameLineEdit->setEnabled( FALSE );
		// 		main->AdvancedSettingsPushButton->setEnabled( FALSE );
		//		buttonCancel->setEnabled( FALSE );
		//buttonOk->setEnabled( FALSE );
	}
}

void NewProfileDialog::authTypeChanged( const TQString& )
{
	if ( main->AuthTypeComboBox->currentItem() == VpnAccountData::AuthenticationType(VpnAccountData::cert ))
	{
		// certificate
		main->PSKLineEdit->setEnabled( FALSE );
		main->LabelPsk->setEnabled( FALSE );

		main->x509certURLRequester->setEnabled( TRUE );
		main->LabelCertificate->setEnabled( TRUE );

		main->certpathURLRequester->setEnabled( TRUE );
		main->LabelCertificatePath->setEnabled( TRUE );
	}
	if ( main->AuthTypeComboBox->currentItem() == VpnAccountData::AuthenticationType(VpnAccountData::psk ))
	{
		// psk
		main->PSKLineEdit->setEnabled( TRUE );
		main->LabelPsk->setEnabled( TRUE );

		main->x509certURLRequester->setEnabled( FALSE );
		main->LabelCertificate->setEnabled( FALSE );

		main->certpathURLRequester->setEnabled( FALSE );
		main->LabelCertificatePath->setEnabled( FALSE );
	}

}

void NewProfileDialog::reject()
{
	TQDialog::reject();
}

void NewProfileDialog::profileNameChanged( const TQString& )
{
	// 	LogOutput->append ( "text changed!" );
	// 	if ( main->ProfileLineEdit->text().isEmpty() )
	// 		buttonOk->setEnabled( FALSE );
	// 	else
	// 		buttonOk->setEnabled( TRUE );
}

TQString NewProfileDialog::getName()
{
	return Name;
}

void NewProfileDialog::importPcfFileClicked()
{
	ImportProfileDialog dlg(GlobalConfig,this, i18n("Import Cisco PCF Profile..."),"");
	dlg.exec();
	dlg.resize(800,dlg.height());
}

void NewProfileDialog::groupPasswordContentChanged()
{
	if (!main->GroupPasswordEdit->text().isEmpty())
		main->CheckGroupPass->setChecked(true);
	else
		main->CheckGroupPass->setChecked(false);
}


void NewProfileDialog::passwordContentChanged()
{
	if (!main->PasswordEdit->text().isEmpty())
		main->CheckUserPass ->setChecked(true);
	else
		main->CheckUserPass->setChecked(false);
}

#include "newprofiledialog.moc"
