/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "configlogoptions.h"
#include <kcolordialog.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqgroupbox.h>
#include <tqpushbutton.h>
#include "widgetnotifyhelper.h"

#include <iostream>

ConfigLogOptions::ConfigLogOptions(TQWidget *parent)
		: ConfigLogOptionsBase(parent)
{
	WidgetNotifyHelper h;
	h.setupChangedAction(this);
	dialogModified=false;
}


ConfigLogOptions::~ConfigLogOptions()
{}

void ConfigLogOptions::errorLogColorClicked()
{
	int result = KColorDialog::getColor( ErrorLogColor );
	if ( result == KColorDialog::Accepted )
		ErrorLogLabel->setPaletteBackgroundColor (ErrorLogColor);
}

void ConfigLogOptions::debugLogColorClicked()
{
	int result = KColorDialog::getColor( DebugLogColor );
	if ( result == KColorDialog::Accepted )
		DebugLogLabel->setPaletteBackgroundColor (DebugLogColor);
}


void ConfigLogOptions::infoLogColorClicked()
{
	int result = KColorDialog::getColor( InfoLogColor );
	if ( result == KColorDialog::Accepted )
		InfoLogLabel->setPaletteBackgroundColor (InfoLogColor);
}

void ConfigLogOptions::remoteLogColorClicked()
{
	int result = KColorDialog::getColor( RemoteLogColor );
	if ( result == KColorDialog::Accepted )
		RemoteLogLabel->setPaletteBackgroundColor (RemoteLogColor);
}

void ConfigLogOptions::successLogColorClicked()
{
	int result = KColorDialog::getColor( SuccessLogColor );
	if ( result == KColorDialog::Accepted )
		SuccessLogLabel->setPaletteBackgroundColor (SuccessLogColor);
}

void ConfigLogOptions::useColorizedLogOutputToggled(bool)
{
	if (UseColorizedLogOutputcheckBox->isChecked() )
		ColorGroupBox->setEnabled(true);
	else
		ColorGroupBox->setEnabled(false);
}

void ConfigLogOptions::backgroundLogColorClicked()
{
	int result = KColorDialog::getColor( BackgroundLogColor );
	if ( result == KColorDialog::Accepted )
		BackgroundLogLabel->setPaletteBackgroundColor (BackgroundLogColor);
}

void ConfigLogOptions::dialogChanged()
{
// 	std::cout << "ConfigLogOptions::dialogChanged()" << std::endl;
	dialogModified=true;
}

#include "configlogoptions.moc"
