    /***************************************************************************
                         undodialog.cpp  -  description
                             -------------------
    begin                : Mon Mai 27 20:08:19 CEST 2002
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "undodialog.h"

// TQt includes
#include <tqlabel.h>
#include <tqlayout.h>

// KDE includes
#include <tdefiledialog.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kprocess.h>
#include <ktextbrowser.h>
#include <kurlrequester.h>

UndoDialog::UndoDialog( TQWidget* parent )
    : KDialogBase( KDialogBase::Plain, i18n("Undo Renaming"),
      KDialogBase::User1 | KDialogBase::Close, KDialogBase::User1, parent, 0, false, true )
{
    UndoDialogLayout = new TQVBoxLayout( plainPage(), 11, 6, "UndoDialogLayout");

    TextLabel1 = new TQLabel( plainPage(), "TextLabel1" );
    TextLabel1->setText( i18n( "Undo script:" ) );
    UndoDialogLayout->addWidget( TextLabel1 );

    scriptname = new KURLRequester( plainPage(), "KURLRequester1" );
    scriptname->setMode( KFile::File | KFile::LocalOnly  );
    scriptname->fileDialog()->setOperationMode( KFileDialog::Opening );

    scriptname->setFilter( i18n("*.krename|KRename undo scripts (*.krename)\n"
                                   "*|All Files (*)") );
    UndoDialogLayout->addWidget( scriptname );

    TextLabel2 = new TQLabel( plainPage(), "TextLabel2" );
    TextLabel2->setText( i18n( "<qt>Undo Scripts are normal shell scripts which can also be executed manually from the command line.</qt>" ) );
    UndoDialogLayout->addWidget( TextLabel2 );

    browser = new KTextBrowser( plainPage());
    browser->setWordWrap( TQTextEdit::NoWrap );
    browser->setTextFormat( TQt::RichText );

    UndoDialogLayout->addWidget( browser );

    setButtonText( KDialogBase::User1, i18n( "&Start" ) );

    connect( this, TQT_SIGNAL( user1Clicked() ), this, TQT_SLOT( start() ) );
    connect( scriptname, TQT_SIGNAL( textChanged( const TQString & ) ), this, TQT_SLOT( enableControls() ) );

    enableControls();
}

UndoDialog::~UndoDialog()
{ }

void UndoDialog::start()
{
    if( scriptname->url().right( 8 ) != ".krename" ) // EXTENSION
        if( KMessageBox::warningContinueCancel( this, i18n("This script does not seem "
                                        "to be a Krename undo script. Execution of this "
                                        "script can be dangerous. Continue ?") )
            == KMessageBox::Cancel )
            return;

    TDEProcess *proc = new TDEProcess;
    *proc << scriptname->url() << "--krename";

    enableButton( KDialogBase::User1, false );

    if( !proc->start( TDEProcess::NotifyOnExit, TDEProcess::AllOutput ) ) {
        KMessageBox::sorry( this, i18n("Unable to start the given undo script!") );
        enableButton( KDialogBase::User1, true );
        delete proc;
        return;
    }
    proc->resume();
    connect( proc, TQT_SIGNAL( receivedStdout( TDEProcess*, char*, int) ), this, TQT_SLOT( receive( TDEProcess*, char*, int ) ) );
    connect( proc, TQT_SIGNAL( receivedStderr( TDEProcess*, char*, int) ), this, TQT_SLOT( receiveErr( TDEProcess*, char*, int ) ) );
    connect( proc, TQT_SIGNAL( processExited( TDEProcess* ) ), this, TQT_SLOT( finished( TDEProcess* ) ) );
}

void UndoDialog::receive( TDEProcess*, char* buffer, int len )
{
    TQString text;
    for( int i = 0; i < len; i++ )
        text.append( buffer[i] );

    browser->setText( browser->text() + text + "<br>");
}

void UndoDialog::receiveErr( TDEProcess*, char* buffer, int len )
{
    TQString text = "<b>";
    for( int i = 0; i < len; i++ )
        text.append( buffer[i] );

    browser->setText( browser->text() + text + "</b><br>");
}

void UndoDialog::finished( TDEProcess* p )
{
    delete p;
    KMessageBox::information( this, i18n("Finished successfully") );
    enableControls();
}

void UndoDialog::enableControls()
{
    TQFileInfo fi( scriptname->url() );
    bool b = !scriptname->url().isEmpty() && fi.exists() && fi.isExecutable();
    enableButton( KDialogBase::User1, b );
}

void UndoDialog::setUndoScript( const TQString & filename )
{
    scriptname->setURL( filename );
}
    
#include "undodialog.moc"


