/***************************************************************************
                          replacedialog.cpp  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Own includes
#include "replacedialog.h"

// QT includes
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqlayout.h>
#include <tqregexp.h>

// KDE includes
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdelistview.h>
#include <tdemessagebox.h>
#include <tdeparts/componentfactory.h>
#include <kpushbutton.h>
#include <kregexpeditorinterface.h>

ReplaceDialog::ReplaceDialog( TQValueList<replacestrings> & r, TQWidget* parent )
    : KDialogBase( KDialogBase::Plain, i18n( "Find and Replace" ),
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, parent, 0, true, true )
{
    ReplaceDialogLayout = new TQGridLayout( plainPage(), 11, 6);

    list = new TDEListView( plainPage() );
    list->addColumn( i18n("Find") );
    list->addColumn( i18n("Replace With") );
    list->addColumn( i18n("Regular Expression") );
    list->addColumn( "regexp" ); // no i18n, because not user visible
//    list->setColumnWidthMode( 0, TQListView::Manual );
//    list->setColumnWidthMode( 1, TQListView::Manual );
//    list->setColumnWidthMode( 2, TQListView::Manual );
    list->setColumnWidthMode( 3, TQListView::Manual );
    list->setColumnWidth( 3, 0 );
    list->setSorting( -1 );
    list->setAllColumnsShowFocus( true );
        
    TextLabel1 = new TQLabel( plainPage() );
    TextLabel1->setText( i18n( "Find:" ) );
    TextLabel2 = new TQLabel( plainPage() );
    TextLabel2->setText( i18n( "Replace with:" ) );

    text1 = new TQLineEdit( plainPage() );
    text2 = new TQLineEdit( plainPage() );

    checkReg = new TQCheckBox( i18n("&Regular expression"), plainPage() );
    buttonRegEdit = new KPushButton( plainPage() );
    buttonRegEdit->setText( i18n( "&Edit..." ) );
    buttonRegEdit->setEnabled( false );

    buttonAdd = new KPushButton( plainPage() );
    buttonAdd->setText( i18n( "&Add" ) );

    buttonEdit = new KPushButton( plainPage() );
    buttonEdit->setText( i18n("&Edit") );
    
    buttonRemove = new KPushButton( plainPage() );
    buttonRemove->setText( i18n( "&Remove" ) );
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );

    ReplaceDialogLayout->addWidget( TextLabel1, 0, 0 );
    ReplaceDialogLayout->addWidget( text1, 0, 1 );

    ReplaceDialogLayout->addWidget( TextLabel2, 0, 3 );
    ReplaceDialogLayout->addWidget( text2, 0, 4 );

    ReplaceDialogLayout->addWidget( checkReg, 1, 0 );
    ReplaceDialogLayout->addWidget( buttonRegEdit, 1, 1 );

    ReplaceDialogLayout->addWidget( buttonAdd, 0, 6 );
    ReplaceDialogLayout->addWidget( buttonEdit, 1, 6 );
    ReplaceDialogLayout->addWidget( buttonRemove, 2, 6 );
    
    ReplaceDialogLayout->addItem( spacer, 0, 5 );
    ReplaceDialogLayout->addItem( spacer, 0, 2 );
    ReplaceDialogLayout->addMultiCellWidget( list, 3, 3, 0, 4 );
    
    text1->setFocus();

    connect( buttonAdd, TQT_SIGNAL( clicked() ), this, TQT_SLOT( add() ) );
    connect( buttonRemove, TQT_SIGNAL( clicked() ), this, TQT_SLOT( remove() ) );
    connect( list, TQT_SIGNAL( clicked( TQListViewItem* ) ), this, TQT_SLOT( enableControls() ) );
    connect( list, TQT_SIGNAL( doubleClicked( TQListViewItem* ) ), this, TQT_SLOT( slotEdit() ) );
    connect( text2, TQT_SIGNAL( returnPressed() ), this, TQT_SLOT( add() ) );
    connect( text1, TQT_SIGNAL( returnPressed() ), this, TQT_SLOT( moveFocus() ) );
    connect( buttonRegEdit, TQT_SIGNAL( clicked() ), this, TQT_SLOT( invokeRegEdit() ) );
    connect( checkReg, TQT_SIGNAL( clicked() ), this, TQT_SLOT( enableControls() ) );
    connect( buttonEdit, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotEdit() ) );

    for( unsigned int i = 0; i < r.count(); i++ ) {
        replacestrings rs = r[i];

        BatchRenamer::unEscape( rs.find );

        TDEListViewItem* item = new TDEListViewItem( list );
        item->setText( 0, encode( rs.find ) );
        item->setText( 1, encode( rs.replace ) );
        item->setText( 2, rs.reg ? i18n("yes") : i18n("no") );
        item->setText( 3, TQString::number( rs.reg ) );
        list->insertItem( item );
    }

    enableControls();
}

ReplaceDialog::~ReplaceDialog()
{ }

void ReplaceDialog::add()
{
    if( text1->text().isEmpty() ) {
        KMessageBox::sorry( this, i18n( "Add a text that should be replaced." ) );
        return;
    }

    TQListViewItem* it = list->firstChild();
    while( it ) {
        if( it->text( 0 ) == text1->text() ) {
            KMessageBox::sorry( this, i18n( "You can't replace the same text twice." ) );
            return;
        }
        it = it->nextSibling();
    }

    TDEListViewItem* item = new TDEListViewItem( list, i18n("Regular expression") );
    item->setText( 0, encode( text1->text() ) );
    item->setText( 1, encode( text2->text() ) );
    item->setText( 2, checkReg->isChecked() ? i18n("yes") : i18n("no") );    
    item->setText( 3, TQString::number( checkReg->isChecked() ) );
    list->insertItem( item );

    reset();

    enableControls();
}

void ReplaceDialog::remove()
{
    if( list->selectedItem() ) {
        TQListViewItem* item = list->selectedItem();
        list->takeItem( item );
        delete item;
    }

    enableControls();    
}

TQValueList<replacestrings> ReplaceDialog::getList()
{
    TQValueList<replacestrings> r;
    TQListViewItem* item = list->firstChild();
    while( item ) {
        replacestrings n;
        n.find = decode( item->text( 0 ) );
        n.replace = decode( item->text( 1 ) );
        n.reg = item->text( 3 ).toInt();

        BatchRenamer::doEscape( n.find );

        r.append( n );

        item = item->nextSibling();
    }
    return r;
}

void ReplaceDialog::moveFocus()
{
    text2->setFocus();
}

void ReplaceDialog::invokeRegEdit()
{
    TQDialog* regExpDialog = KParts::ComponentFactory::createInstanceFromQuery<TQDialog>( "KRegExpEditor/KRegExpEditor", TQString(), TQT_TQOBJECT(this) );

    KRegExpEditorInterface *iface = static_cast<KRegExpEditorInterface *>( regExpDialog->tqt_cast( "KRegExpEditorInterface" ) );
    if ( !iface )
        return;

    iface->setRegExp( text1->text() );
    bool ok = regExpDialog->exec();
    if ( ok )
        text1->setText( iface->regExp() );
}

TQString ReplaceDialog::encode( TQString s )
{
    s.append("\"");
    s.prepend("\"");
    return s;
}

TQString ReplaceDialog::decode( TQString s )
{
    if( s[0] == '"' )
        s.remove( 0, 1 );

    if( s[s.length()-1] == '"' )
        s.remove( s.length()-1, 1 );
    return s;
}

void ReplaceDialog::resizeEvent( TQResizeEvent* e )
{
    TQDialog::resizeEvent( e );
//    list->setColumnWidth( 0, TextLabel1->width() + text1->width() );
//    list->setColumnWidth( 1, TextLabel2->width() + text2->width() );
}

void ReplaceDialog::reset()
{
    text1->clear();
    text2->clear();
    checkReg->setChecked( false );
    text1->setFocus();
}

void ReplaceDialog::enableControls()
{
    buttonRemove->setEnabled( list->selectedItem() );
    buttonRegEdit->setEnabled( checkReg->isChecked() && !TDETrader::self()->query("KRegExpEditor/KRegExpEditor").isEmpty() );
    buttonEdit->setEnabled( list->selectedItem() );
}

void ReplaceDialog::slotEdit()
{
    text1->setText( decode( list->selectedItem()->text( 0 ) ) );
    text2->setText( decode( list->selectedItem()->text( 1 ) ) );
    checkReg->setChecked( list->selectedItem()->text( 3 ).toInt() );

    TQListViewItem* item = list->selectedItem();
    list->takeItem( item );
    delete item;
    
    text1->setFocus();

    enableControls();
}

#include "replacedialog.moc"
