/***************************************************************************
                  encodingplugin.cpp  -  description
                             -------------------
    begin                : Tue Jul 06 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "encodingplugin.h"

// QT includes
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqtextcodec.h>
#include <tqvgroupbox.h>


// KDE includes
#include <tdeapplication.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

const TQString EncodingPlugin::getName() const
{
    return i18n("Encoding Conversion Plugin");
}

const TQString EncodingPlugin::getAccelName() const
{
    return i18n("&Encoding Conversion Plugin");
}

const int EncodingPlugin::type() const
{
    return TYPE_FINAL_FILENAME;
}

void EncodingPlugin::drawInterface( TQWidget* w, TQVBoxLayout* l )
{
    // build a list of all available TextCodecs
    TQStringList codecs;
    TQTextCodec *codec;
    for( int i=0; (codec = TQTextCodec::codecForIndex(i));i++)
        codecs.append( codec->name() );

    m_widget = w;

    codec = TQTextCodec::codecForLocale();
    m_locale_codec = codec->name();

    TQLabel* label = new TQLabel( 
	i18n("<qt>This plugin is able to convert filenames between different "
	     "encodings. For example you can convert filenames from KOI8-R "
	     "to UTF-8 encoding.</qt>"), w );
    l->addWidget( label );
    
    TQVGroupBox* groupInput = new TQVGroupBox( i18n("Encoding of Input Files:"), w );
    checkInput = new TQCheckBox( i18n("&Use local encoding: %1").arg( m_locale_codec), groupInput );
    comboInput = new KComboBox( false, groupInput );
    comboInput->insertStringList( codecs );

    TQVGroupBox* groupOutput = new TQVGroupBox( i18n("Encoding of Output Files:"), w );
    checkOutput = new TQCheckBox( i18n("&Use local encoding: %1").arg( m_locale_codec), groupOutput );
    checkOutput->setChecked( true );
    comboOutput = new KComboBox( false, groupOutput );
    comboOutput->insertStringList( codecs );

    l->addWidget( groupInput );
    l->addWidget( groupOutput );

    connect( checkInput, TQT_SIGNAL( clicked() ), this, TQT_SLOT( enableControls() ) );
    connect( checkOutput, TQT_SIGNAL( clicked() ), this, TQT_SLOT( enableControls() ) );

    connect( comboOutput, TQT_SIGNAL( activated(int) ),this, TQT_SLOT( updatePreview() ) );
    connect( comboInput, TQT_SIGNAL( activated(int) ),this, TQT_SLOT( updatePreview() ) );

    setLocale( comboInput );
    setLocale( comboOutput );

    enableControls();
}

void EncodingPlugin::fillStructure()
{
    m_input_codec = (checkInput->isChecked() ? m_locale_codec : comboInput->currentText() );
    m_output_codec = (checkOutput->isChecked() ? m_locale_codec : comboOutput->currentText() );
} 

bool EncodingPlugin::checkError()
{
   return true;
}

TQString EncodingPlugin::processFile( BatchRenamer*, int, TQString token, int )
{
    TQString input   = token;
    TQString unicode = TQString();

    TQTextCodec* toUnicode = TQTextCodec::codecForName(m_input_codec.ascii()); // get the codec for KOI8-R
    TQTextCodec* fromUnicode = TQTextCodec::codecForName(m_output_codec.ascii());

    unicode = toUnicode->toUnicode( input.ascii() );
    return fromUnicode->fromUnicode( unicode.ascii() );
}

void EncodingPlugin::finished()
{
}


const TQPixmap EncodingPlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "fonts", TDEIcon::Small );
}

void EncodingPlugin::enableControls()
{
    comboInput->setEnabled( !checkInput->isChecked() );
    comboOutput->setEnabled( !checkOutput->isChecked() );

    //updatePreview();
}

void EncodingPlugin::setLocale( KComboBox* combo )
{
    for(int i=0;i<combo->count();i++)
	if( combo->text(i) == m_locale_codec )
	{
	    combo->setCurrentItem( i );
	    break;
	}
}

#include "encodingplugin.moc"
