/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#ifndef _LOGGINGOPTIONS_
#define _LOGGINGOPTIONS_

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <ntqwidget.h>
#include "global.h"

//	forward class definitions
//	=========================

class TQCheckBox;
class TQLineEdit;
class TQPushButton;
class TDEConfig;

//	LoggingOptions class definition
//	===============================

class LoggingOptions : public TQWidget
{	TQ_OBJECT

	public:
		LoggingOptions( TQWidget* parent, const char* name = NULL );

		void finaliseInitialisation( );
		bool getOptions( );
		void readProfile( TDEConfig* config );
		void saveProfile( TDEConfig* config );
		void setInitialValues( );

		bool    appendOutputState( ) const { return m_appendOutputState; }
		bool    baseFileNameState( ) const { return m_baseFileNameState; }
		TQString baseFileNameValue( ) const { return m_baseFileNameValue; }
		bool    grepableLogState( )  const { return m_grepableLogState;  }
		TQString grepableLogValue( )  const { return m_grepableLogValue;  }
		bool    normalLogState( )    const { return m_normalLogState;    }
		TQString normalLogValue( )    const { return m_normalLogValue;    }
		bool    noStylesheetState( ) const { return m_noStylesheetState; }
		bool    resumeState( )       const { return m_resumeState;       }
		TQString resumeValue( )       const { return m_resumeValue;       }
		bool    scriptKiddieState( ) const { return m_scriptKiddieState; }
		TQString scriptKiddieValue( ) const { return m_scriptKiddieValue; }
		bool    stylesheetState( )   const { return m_stylesheetState;   }
		TQString stylesheetValue( )   const { return m_stylesheetValue;   }
		bool    xmlLogState( )       const { return m_xmlLogState;       }
		TQString xmlLogValue( )       const { return m_xmlLogValue;       }

	signals:
		void displayDocBook( const TQString& );
		void displayHelp( const TQString& );
		void displayUnknown( );
		void optionsDirty( );

	private slots:
		void slotBaseFileNameButtonClicked( );
		void slotBaseFileNameCheckBoxClicked( );
		void slotGrepableLogButtonClicked( );
		void slotGrepableLogCheckBoxClicked( );
		void slotNormalLogButtonClicked( );
		void slotNormalLogCheckBoxClicked( );
		void slotNoStylesheetCheckBoxClicked( );
		void slotResumeButtonClicked( );
		void slotResumeCheckBoxClicked( );
		void slotScriptKiddieButtonClicked( );
		void slotScriptKiddieCheckBoxClicked( );
		void slotStylesheetButtonClicked( );
		void slotStylesheetCheckBoxClicked( );
		void slotWhatsThisClicked( );
		void slotXMLLogButtonClicked( );
		void slotXMLLogCheckBoxClicked( );

	private:
		void createLayout( );

		TQCheckBox*   m_appendOutputCheckBox;
		bool         m_appendOutputState;
		TQPushButton* m_baseFileNameButton;
		TQCheckBox*   m_baseFileNameCheckBox;
		TQLineEdit*   m_baseFileNameLineEdit;
		bool         m_baseFileNameState;
		TQString      m_baseFileNameValue;
		TQPushButton* m_grepableLogButton;
		TQCheckBox*   m_grepableLogCheckBox;
		TQLineEdit*   m_grepableLogLineEdit;
		bool         m_grepableLogState;
		TQString      m_grepableLogValue;
		TQPushButton* m_normalLogButton;
		TQCheckBox*   m_normalLogCheckBox;
		TQLineEdit*   m_normalLogLineEdit;
		bool         m_normalLogState;
		TQString      m_normalLogValue;
		TQCheckBox*   m_noStylesheetCheckBox;
		bool         m_noStylesheetState;
		TQPushButton* m_resumeButton;
		TQCheckBox*   m_resumeCheckBox;
		TQLineEdit*   m_resumeLineEdit;
		bool         m_resumeState;
		TQString      m_resumeValue;
		TQPushButton* m_scriptKiddieButton;
		TQCheckBox*   m_scriptKiddieCheckBox;
		TQLineEdit*   m_scriptKiddieLineEdit;
		bool         m_scriptKiddieState;
		TQString      m_scriptKiddieValue;
		TQPushButton* m_stylesheetButton;
		TQCheckBox*   m_stylesheetCheckBox;
		TQLineEdit*   m_stylesheetLineEdit;
		bool         m_stylesheetState;
		TQString      m_stylesheetValue;
		TQPushButton* m_xmlLogButton;
		TQCheckBox*   m_xmlLogCheckBox;
		TQLineEdit*   m_xmlLogLineEdit;
		bool         m_xmlLogState;
		TQString      m_xmlLogValue;
};

#endif	// _LOGGINGOPTIONS_
