// This module implements the TQextScintillaCommand class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <tqnamespace.h>
#include <tqapplication.h>

#include "tqextscintillacommand.h"
#include "tqextscintilla.h"
#include "tqextscintillabase.h"


static int convert(int key);


// The ctor.
TQextScintillaCommand::TQextScintillaCommand(TQextScintilla *qs,int msg,int key,
					   int altkey, const char *desc) :
						qsCmd(qs), msgCmd(msg),
						qkey(key), qaltkey(altkey),
						descCmd(desc)
{
	scikey = convert(qkey);

	if (scikey)
		qsCmd -> SendScintilla(TQextScintillaBase::SCI_ASSIGNCMDKEY,scikey,msgCmd);

	scialtkey = convert(qaltkey);

	if (scialtkey)
		qsCmd -> SendScintilla(TQextScintillaBase::SCI_ASSIGNCMDKEY,scialtkey,msgCmd);
}


// Bind a key to a command.
void TQextScintillaCommand::setKey(int key)
{
	bindKey(key,qkey,scikey);
}


// Bind an alternate key to a command.
void TQextScintillaCommand::setAlternateKey(int altkey)
{
	bindKey(altkey,qaltkey,scialtkey);
}


// Do the hard work of binding a key.
void TQextScintillaCommand::bindKey(int key,int &qk,int &scik)
{
	int new_scikey;

	// Ignore if it is invalid, allowing for the fact that we might be
	// unbinding it.
	if (key)
	{
		new_scikey = convert(key);

		if (!new_scikey)
			return;
	}
	else
		new_scikey = 0;

	if (scik)
		qsCmd -> SendScintilla(TQextScintillaBase::SCI_CLEARCMDKEY,scik);

	qk = key;
	scik = new_scikey;

	if (scik)
		qsCmd -> SendScintilla(TQextScintillaBase::SCI_ASSIGNCMDKEY,scik,msgCmd);
}


// See if a key is valid.
bool TQextScintillaCommand::validKey(int key)
{
	return convert(key);
}


// Convert a TQt character to the Scintilla equivalent.  Return zero if it is
// invalid.
static int convert(int key)
{
	// Convert the modifiers.
	int sci_mod = 0;

	if (key & TQt::SHIFT)
		sci_mod |= TQextScintillaBase::SCMOD_SHIFT;

	if (key & TQt::CTRL)
		sci_mod |= TQextScintillaBase::SCMOD_CTRL;

	if (key & TQt::ALT)
		sci_mod |= TQextScintillaBase::SCMOD_ALT;

	key &= ~TQt::MODIFIER_MASK;

	// Convert the key.
	int sci_key;

	if (key > 0x7f)
		switch (key)
		{
		case TQt::Key_Down:
			sci_key = TQextScintillaBase::SCK_DOWN;
			break;

		case TQt::Key_Up:
			sci_key = TQextScintillaBase::SCK_UP;
			break;

		case TQt::Key_Left:
			sci_key = TQextScintillaBase::SCK_LEFT;
			break;

		case TQt::Key_Right:
			sci_key = TQextScintillaBase::SCK_RIGHT;
			break;

		case TQt::Key_Home:
			sci_key = TQextScintillaBase::SCK_HOME;
			break;

		case TQt::Key_End:
			sci_key = TQextScintillaBase::SCK_END;
			break;

		case TQt::Key_Prior:
			sci_key = TQextScintillaBase::SCK_PRIOR;
			break;

		case TQt::Key_Next:
			sci_key = TQextScintillaBase::SCK_NEXT;
			break;

		case TQt::Key_Delete:
			sci_key = TQextScintillaBase::SCK_DELETE;
			break;

		case TQt::Key_Insert:
			sci_key = TQextScintillaBase::SCK_INSERT;
			break;

		case TQt::Key_Escape:
			sci_key = TQextScintillaBase::SCK_ESCAPE;
			break;

		case TQt::Key_Backspace:
			sci_key = TQextScintillaBase::SCK_BACK;
			break;

		case TQt::Key_Tab:
			sci_key = TQextScintillaBase::SCK_TAB;
			break;

		case TQt::Key_Return:
			sci_key = TQextScintillaBase::SCK_RETURN;
			break;

		default:
			sci_key = 0;
		}
	else
		sci_key = key;

	if (sci_key)
		sci_key |= (sci_mod << 16);

	return sci_key;
}


// Return the translated user friendly description.
TQString TQextScintillaCommand::description() const
{
	return tqApp -> translate("TQextScintillaCommand",descCmd);
}
