//
// C++ Interface: tdewalletaccess
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef TDEWALLETACCESS_H
#define TDEWALLETACCESS_H

//TQt headers
#include <tqstring.h>

//KDE headers
#include <tdewallet.h>
#include <tdemessagebox.h>
#include <kdebug.h>
#include <tdelocale.h>

/**
 * @brief Provides routines to save and read passwords using TDEWallet.
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
namespace TDEWalletAccess
{

  /**
   * Saves the given password into TDEWallet.
   * @param account account name
   * @param password the password
   * @return TRUE - password successfully saved
   * @return FALSE - password could not be saved
   */
  bool savePassword( const TQString& account, const TQString& password );

  /**
   * Returns the password of the given account.
   * @param account account name
   * @return the password or TQString::null, if the sought password is not stored in TDEWallet.
   */
  TQString getPassword( const TQString& account );
}

#endif
