/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CHTMLREADDISPLAY_H
#define CHTMLREADDISPLAY_H

//BibleTime includes
#include "creaddisplay.h"
//#include "frontend/ctooltip.h"

//TQt includes
#include <tqstring.h>
#include <tqwidget.h>

//KDE includes
#include <tdehtml_part.h>
#include <tdehtmlview.h>
#include <tdeparts/browserextension.h>

class CHTMLReadDisplayView;

/** The implementation for the HTML read display.
  * @author The BibleTime team
  */
class CHTMLReadDisplay : public TDEHTMLPart, public CReadDisplay {
	TQ_OBJECT
  
public:
	//reimplemented functions from CDisplay
	/**
	* Returns the right text part in the specified format.
	*/
	virtual const TQString text( const CDisplay::TextType format = CDisplay::HTMLText, const CDisplay::TextPart part = CDisplay::Document );
	/**
	* Sets the new text for this display widget.
	*/
	virtual void setText( const TQString& newText );
	virtual const bool hasSelection();
	/**
	* Reimplementation.
	*/
	virtual TQScrollView* view();
	virtual void selectAll();
	virtual void moveToAnchor( const TQString& anchor );

	virtual void zoomIn();
	virtual void zoomOut();
	virtual void openFindTextDialog();
	
	virtual TQMap<CDisplay::NodeInfoType, TQString> getCurrentNodeInfo() {
		return m_nodeInfo;
	}

protected:
	friend class CDisplay;
	CHTMLReadDisplay( CReadWindow* readWindow, TQWidget* parent = 0 );
	virtual ~CHTMLReadDisplay();

	virtual void urlSelected( const TQString& url, int button, int state, const TQString& _target, KParts::URLArgs args);
	/**
	* Reimplementation.
	*/
	virtual void tdehtmlMouseReleaseEvent( tdehtml::MouseReleaseEvent* event );
	virtual void tdehtmlMousePressEvent( tdehtml::MousePressEvent* event );
	virtual void tdehtmlMouseMoveEvent( tdehtml::MouseMoveEvent* event );
	virtual void timerEvent(TQTimerEvent *event);


	struct DNDData {
		bool mousePressed;
		bool isDragging;
		DOM::Node node;
		DOM::DOMString anchor;
		TQString selection;
		TQPoint startPos;
		enum DragType {
			Link,
			Text
		} dragType;
	}
	m_dndData;

	TQMap<NodeInfoType, TQString> m_nodeInfo;
		
private:
	CHTMLReadDisplayView* m_view;
	struct URLWorkaroundData {
		bool doWorkaround;
		TQString url;
		int button;
		int state;
		TQString target;
		KParts::URLArgs args;

		TQString module;
		TQString key;
	}
	m_urlWorkaroundData;

	DOM::Node m_previousEventNode;
	TQString m_currentAnchorCache;

protected slots:
	void slotGoToAnchor();
};

class CHTMLReadDisplayView : public TDEHTMLView, public CPointers {
	TQ_OBJECT
  
protected: // Protected methods
	friend class CHTMLReadDisplay;


	CHTMLReadDisplayView(CHTMLReadDisplay* display, TQWidget* parent);
	/**
	* Reimplementation from TQScrollView. Sets the right slots
	*/
	virtual void polish();
	/**
	* Reimplementatiob from TQScrollView.
	*/
	virtual void contentsDropEvent( TQDropEvent* );
	/**
	* Reimplementatiob from TQScrollView.
	*/
	virtual void contentsDragEnterEvent( TQDragEnterEvent* );

protected slots: // Protected slots
	/**
	* Opens the popupmenu at the given position.
	*/
	void popupMenu( const TQString&, const TQPoint& );

private:
	CHTMLReadDisplay* m_display;
};

#endif
