/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



//BT includes
#include "cswordsetupinstallsourcesdialog.h"
#include "util/scoped_resource.h"

//TQt includes
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcombobox.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqmessagebox.h>
#include <tqfileinfo.h>


#include <tdelocale.h>
#include <kdirselectdialog.h>

namespace BookshelfManager {

	const TQString PROTO_FILE( i18n("Local") ); //Local path
	const TQString PROTO_FTP( i18n("Remote") ); //Remote path


	CSwordSetupInstallSourcesDialog::CSwordSetupInstallSourcesDialog(/*TQWidget *parent*/)
: TQDialog() {

		TQVBoxLayout* mainLayout = new TQVBoxLayout( this );
		mainLayout->setMargin( 10 );
		mainLayout->setSpacing( 5 );

		TQHBoxLayout *captionLayout = new TQHBoxLayout( mainLayout );
		TQLabel *label = new TQLabel( i18n("Caption"), this );
		captionLayout->addWidget( label );

		m_captionEdit = new TQLineEdit( this );
		m_captionEdit->setText("Crosswire Bible Society");
		captionLayout->addWidget( m_captionEdit );

		mainLayout->addSpacing( 10 );

		TQGridLayout* layout = new TQGridLayout( mainLayout, 3, 3 );
		layout->setSpacing( 5 );

		label = new TQLabel(i18n("Type"), this);
		layout->addWidget( label, 0, 0);

		m_serverLabel = new TQLabel(i18n("Server"), this);
		layout->addWidget( m_serverLabel, 0, 1);

		label = new TQLabel(i18n("Path"), this);
		layout->addWidget( label, 0, 2 );

		m_protocolCombo = new TQComboBox( this );
		layout->addWidget(m_protocolCombo, 1, 0);
		m_protocolCombo->insertItem( PROTO_FTP  );
		m_protocolCombo->insertItem( PROTO_FILE );

		m_serverEdit = new TQLineEdit( this );
		layout->addWidget( m_serverEdit, 1, 1 );
		m_serverEdit->setText("ftp.crosswire.org");

		m_pathEdit = new TQLineEdit( this );
		layout->addWidget( m_pathEdit, 1, 2 );
		m_pathEdit->setText("/pub/sword/raw");

		mainLayout->addSpacing( 10 );

		TQHBoxLayout* buttonLayout = new TQHBoxLayout( mainLayout );
		buttonLayout->addStretch();
		TQPushButton* okButton = new TQPushButton( i18n("Ok"), this);
		TQPushButton* discardButton = new TQPushButton( i18n("Discard"), this);
		buttonLayout->addWidget( discardButton);
		buttonLayout->addWidget( okButton);
		buttonLayout->addStretch();

		connect( okButton, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotOk() ) );
		connect( discardButton, TQT_SIGNAL( clicked() ), this, TQT_SLOT( reject() ) );
		connect( m_protocolCombo, TQT_SIGNAL( activated(int) ), this, TQT_SLOT( slotProtocolChanged() ) );

	}
	void CSwordSetupInstallSourcesDialog::slotOk() {
		//run a few tests to validate the input first
		if ( m_captionEdit->text().stripWhiteSpace().isEmpty() ) { //no caption
			TQMessageBox::information( this, i18n( "Error" ), i18n("Please provide a caption."), TQMessageBox::Retry);
			return;
		}

		BTInstallMgr iMgr;
		sword::InstallSource is = BTInstallMgr::Tool::RemoteConfig::source( &iMgr, m_captionEdit->text() );
		if ( (TQString)is.caption.c_str() == m_captionEdit->text() ) { //source already exists
			TQMessageBox::information( this, i18n( "Error" ),
									  i18n("A source with this caption already exists.<br>Please provide a different caption."), TQMessageBox::Retry);
			return;
		}

		if ( m_protocolCombo->currentText() == PROTO_FTP &&
				m_serverEdit->text().stripWhiteSpace().isEmpty() ) { //no server name
			TQMessageBox::information( this, i18n( "Error" ), i18n("Please provide a server name."), TQMessageBox::Retry);
			return;
		}

		if ( m_protocolCombo->currentText() == PROTO_FILE) {
			const TQFileInfo fi( m_pathEdit->text() );
			if (!fi.exists() || !fi.isReadable()) { //no valid and readable path
				TQMessageBox::information( this, i18n( "Error" ), i18n("Please provide a valid, readable path."), TQMessageBox::Retry);
				return;
			}
			else if ( m_pathEdit->text().isEmpty() ) {
				TQMessageBox::information( this, i18n( "Error" ), i18n("Please provide a path."), TQMessageBox::Retry);

			}
		}

		accept(); //only if nothing else failed
	}

	void CSwordSetupInstallSourcesDialog::slotProtocolChanged() {
		if (m_protocolCombo->currentText() == PROTO_FTP) { //REMOTE
			m_serverLabel->show();
			m_serverEdit->show();
		}
		else { //LOCAL, no server needed
			m_serverLabel->hide();
			m_serverEdit->hide();

			KURL url = KDirSelectDialog::selectDirectory(TQString(), true);
			if (url.isValid()) {
				m_pathEdit->setText( url.path() );
			}
		}

	}

	sword::InstallSource CSwordSetupInstallSourcesDialog::getSource() {

		util::scoped_ptr<CSwordSetupInstallSourcesDialog> dlg( new CSwordSetupInstallSourcesDialog() );
		sword::InstallSource newSource(""); //empty, invalid Source

		if (dlg->exec() == TQDialog::Accepted) {
			if (dlg->m_protocolCombo->currentText() == PROTO_FTP) {
				newSource.type = "FTP";
				newSource.source = dlg->m_serverEdit->text().utf8();

				//a message to the user would be nice, but we're in message freeze right now (1.5.1)
				if (dlg->m_serverEdit->text().right(1) == "/") { //remove a trailing slash
					newSource.source  = dlg->m_serverEdit->text().mid(0, dlg->m_serverEdit->text().length()-1).utf8();
				}
			}
			else {
				newSource.type = "DIR";
				newSource.source = "local";
			}
			newSource.caption = dlg->m_captionEdit->text().utf8();
			newSource.directory = dlg->m_pathEdit->text().utf8();
		}

		return newSource;
	}


} //namespace

#include "cswordsetupinstallsourcesdialog.moc"
