/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CPRINTER_H
#define CPRINTER_H

//BibleTime backend
#include "backend/cswordbackend.h"
#include "backend/cdisplayrendering.h"

//BibleTime frontend
#include "frontend/cbtconfig.h"

//TQt includes
#include <tqobject.h>

class TDEHTMLPart;

namespace Printing {

	/**
	 * The CPrinter class manages the print item queue and the printing of them to the printer.
	 *
	 * @author The BibleTime team
	*/
class CPrinter : public TQObject, public Rendering::CDisplayRendering {
		TQ_OBJECT
  
public:
		CPrinter(
			TQObject *parent, CSwordBackend::DisplayOptions displayOptions, CSwordBackend::FilterOptions filterOptions
		);

		virtual ~CPrinter();

		void printKeyTree( KeyTree& );

protected:
		virtual const TQString entryLink(const KeyTreeItem& item, CSwordModuleInfo* const module);
		virtual const TQString renderEntry( const KeyTreeItem&, CSwordKey* = 0 );
		virtual const TQString finishText(const TQString& arg1, KeyTree& tree);

private:
		TDEHTMLPart* m_htmlPart;
	};

}

#endif
