/***************************************************************************
    smb4knetworkbrowser  -  The network browser widget of Smb4K.
                             -------------------
    begin                : Mo Jan 8 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KNETWORKBROWSER_H
#define SMB4KNETWORKBROWSER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <tdelistview.h>

// forward declarations
class Smb4KNetworkBrowserItem;
class Smb4KNetworkBrowserToolTip;

class Smb4KNetworkBrowser : public TDEListView
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor
     *
     * @param parent        The parent widget
     *
     * @param name          The widget name
     */
    Smb4KNetworkBrowser( TQWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor
     */
    ~Smb4KNetworkBrowser();

    /**
     * Enumeration for the columns in the list view.
     */
    enum Columns{ Network = 0, Type = 1, IP = 2, Comment = 3 };

    /**
     * Returns the global position of the mouse with respect
     * to the viewport.
     *
     * @returns the position of the mouse.
     */
    const TQPoint &mousePosition() { return m_pos; }

    /**
     * Returns a pointer to the current tool tip or NULL, if there
     * is no tool tip at the moment. Please note, that the tool tip
     * is generated 2 sec before it is shown.
     *
     * @returns a pointer to the current tool tip.
     */
    Smb4KNetworkBrowserToolTip *tooltip() { return m_tooltip; }

    /**
     * Block the showing of tool tips. If @p block is set to TRUE, the
     * current tool tip gets deleted (if there is one) and no tool tip
     * will be shown until @p block is reset to FALSE.
     *
     * @param block         Set this parameter to TRUE to block the showing
     *                      of tool tips.
     */
    void blockToolTips( bool block );

  signals:
    /**
     * This signal is emitted when the tool tip is about to be shown.
     *
     * @param item          The item for which the tool tip should be shown.
     */
    void aboutToShowToolTip( Smb4KNetworkBrowserItem *item );

    /**
     * This signal is emitted when the tool tip has been closed.
     */
    void closedToolTip();

  protected:
    /**
     * Reimplemented from TQListView. This slot keeps track of the
     * mouse position and handles the tool tips.
     *
     * @param e             The mouse event
     */
    void contentsMouseMoveEvent( TQMouseEvent *e );

  protected slots:
    /**
     * This slot is called whenever a TQListViewItem is expanded or
     * collapsed. At the moment it is only used to select the item.
     *
     * @param item          The list view item that has been
     *                      expanded/collapsed.
     */
    void slotItemExpandedCollapsed( TQListViewItem *item );

    /**
     * This slot is called when the user executed an item. It is used
     * to open the item if it is expandable.
     *
     * @param item          The item that has been executed.
     */
    void slotItemExecuted( TQListViewItem *item );

    /**
     * This slot shows the tool tip.
     */
    void slotShowToolTip();

  private:
    /**
     * The global position of the mouse with respect to the widget.
     */
    TQPoint m_pos;

    /**
     * The tool tip for the network browser
     */
    Smb4KNetworkBrowserToolTip *m_tooltip;

    /**
     * Block tool tips
     */
    bool m_block_tooltip;
};

#endif
