/***************************************************************************
 *   Copyright (C) 2004 by Massimo Callegari                               *
 *   massimocallegari@yahoo.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

// TQt includes
#include <tqapplication.h>
#include <tqlabel.h>
#include <tqtooltip.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqheader.h>
#include <tqvaluelist.h>
#include <tqpixmap.h>
#include <tqtoolbutton.h>
#include <tqtoolbar.h>
#include <tqdir.h>
#include <tqpushbutton.h>

// KDE includes
#include <klibloader.h>
#include <kinstance.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <tdemessagebox.h>
#include <kdialogbase.h>
#include <kcombobox.h>
#include <tdetoolbarbutton.h>
#include <tdeaction.h>
#include <tdeactionclasses.h>
#include <tdeconfigdialog.h>

// plugin specific includes
// #include "smb4k_konqplugin.moc"
#include "smb4k_konqplugin.h"
#include "../smb4k/core/smb4kcore.h"
#include "../smb4k/core/smb4kdefs.h"

smb4kWidget::smb4kWidget( TQWidget * parent, const char * name, WFlags f )
                 : TQVBox(parent, name, f)
{
 // Nothing exciting to do !
}

KonqSidebar_Smb4K::KonqSidebar_Smb4K(TDEInstance *inst,TQObject *parent,TQWidget *widgetParent, TQString &desktopName, const char* name):
                   KonqSidebarPlugin(inst,parent,widgetParent,desktopName,name)
{

  widget = new smb4kWidget( widgetParent );

  TDEToolBar  *topBar = new TDEToolBar( widget, "Topbar" );
  topBar->setIconSize(16);
  topBar->insertButton( "reload",    0, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotRescan() ) , TRUE, i18n( "Scan Network" ) );
  topBar->insertButton( "edit-find",      1, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotSearch() ) , TRUE,  i18n( "Search" ) );
  topBar->insertButton( "configure", 2, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotSmb4KOptionsDlg() ) , TRUE,  i18n( "Configure" ) );

  //
  // Browser widget:
  //
  KLibFactory *browser_factory = KLibLoader::self()->factory( "libsmb4knetworkbrowser" );

  if ( browser_factory )
  {
    m_browser_part = static_cast<KParts::Part *>( browser_factory->create( TQT_TQOBJECT(widget), "BrowserPart", "KParts::Part", TQStringList( "konqplugin=\"true\"" ) ) );

    // Do nothing here. The network scan (and the mounting of recently used
    // shares) will be done by Smb4KCore::init() below.
  }
  else
  {
    KMessageBox::error( 0, "<qt>"+KLibLoader::self()->lastErrorMessage()+"</qt>" );

    return;
  }

  connect( Smb4KCore::mounter(), TQT_SIGNAL( mountedShare( const TQString &) ), this, TQT_SLOT( slotMountedShare( const TQString & ) ) );
  connect( Smb4KCore::mounter(), TQT_SIGNAL( aboutToUnmount( const TQString& ) ), this, TQT_SLOT( slotPrepareUnmount( const TQString& ) ) );

  // Scan the network and remount recently used shares:
  Smb4KCore::self()->init();

}


KonqSidebar_Smb4K::~KonqSidebar_Smb4K()
{

}

extern "C"
{
    void* create_konqsidebar_smb4k(TDEInstance *instance,TQObject *par,TQWidget *widp,TQString &desktopname,const char *name)
    {
     TDEGlobal::locale()->insertCatalogue("smb4k");
     return new KonqSidebar_Smb4K(instance,par,widp,desktopname,name);
    }
};

extern "C"
{
 bool add_konqsidebar_smb4k(TQString* fn, TQString* /*param*/, TQMap<TQString,TQString> *map)
     {
      map->insert("Type","Link");
      map->insert("Icon","smb4k");
      map->insert("Name",i18n("Samba Browser"));
      map->insert("Open","false");
      map->insert("X-TDE-KonqSidebarModule","konqsidebar_smb4k");
      fn->setLatin1("smb4k%1.desktop");
      return true;
     }
}

void KonqSidebar_Smb4K::handleURL(const KURL &url)
{
 currentKonquerorURL = url.path();
 //kdDebug() << "KonqSidebar_Smb4K::handleURL - "<< currentKonquerorURL << endl;
}

void KonqSidebar_Smb4K::slotRescan()
{
  // Send a custom rescan event to the browser part.
  TQApplication::postEvent( m_browser_part, new TQCustomEvent( EVENT_SCAN_NETWORK ) );
}

void KonqSidebar_Smb4K::slotSearch()
{
  // Load the factory of the config dialog:
  KLibFactory *search_factory = KLibLoader::self()->factory( "libsmb4ksearchdialog" );

  if ( search_factory )
  {
    KDialogBase *searchDialog = new KDialogBase( KDialogBase::Plain, i18n( "Search Dialog" ), KDialogBase::Close,
                                              KDialogBase::NoDefault, widget, "sd", true, true );

    TQFrame *frame = searchDialog->plainPage();

    m_search_part = static_cast<KParts::Part *>( search_factory->create( TQT_TQOBJECT(frame), "SearchDialogPart", "KParts::Part" ) );

    if ( m_search_part )
    {
      TQGridLayout *layout = new TQGridLayout( frame );
      layout->setSpacing( 10 );
      layout->setMargin( 0 );
      layout->addWidget ( m_search_part->widget(), 0, 0, 0 );
      searchDialog->resize(400,300);
      // We do not want the dialog to be closed if the user presses return.
      // Instead we want that a search is started:
      searchDialog->actionButton( KDialogBase::Close )->setAutoDefault( false );

      //connect( m_search_dialog, TQT_SIGNAL( searchResult( Smb4KHostItem * ) ), this, TQT_SLOT( slotInsertItem( Smb4KHostItem * ) ) );

      searchDialog->show();
    }
    else
    {
      delete searchDialog;
    }
  }
  else
  {
    KMessageBox::error( 0, "<qt>"+KLibLoader::self()->lastErrorMessage()+"</qt>" );

    return;
  }
}

void KonqSidebar_Smb4K::slotSmb4KOptionsDlg()
{
  // Load the factory of the config dialog:
  KLibFactory *config_factory = KLibLoader::self()->factory( "libsmb4tdeconfigdialog" );

  if ( config_factory )
  {
    TDEConfigDialog *dlg = static_cast<TDEConfigDialog *>( TQT_TQWIDGET(config_factory->create( TQT_TQOBJECT(widget), "ConfigDialog", "TDEConfigDialog" )) );

    if ( dlg )
    {
      connect( dlg,  TQT_SIGNAL( settingsChanged() ), this, TQT_SLOT( slotSettingsChanged() ) );

      dlg->show();
    }
  }
  else
  {
    KMessageBox::error( 0, "<qt>"+KLibLoader::self()->lastErrorMessage()+"</qt>" );

    return;
  }

}

void KonqSidebar_Smb4K::slotSettingsChanged()
{
  TQApplication::postEvent( m_browser_part, new TQCustomEvent( EVENT_LOAD_SETTINGS ) );
}

void KonqSidebar_Smb4K::slotMountedShare( const TQString &mountedShare )
{
 emit openURLRequest( KURL(mountedShare) );
}

void KonqSidebar_Smb4K::slotPrepareUnmount( const TQString &mountpoint )
{
  if ( TQString::compare( currentKonquerorURL, mountpoint ) == 0 )
  {
    emit openURLRequest( KURL( TQDir::home().canonicalPath() ) );
  }
  else
  {
    // Nothing to do
  }
}

#include "smb4k_konqplugin.moc"





