/**************************************************************************

    tdemidframe.cpp  - The main widget of KMid
    Copyright (C) 1997,98  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple

    Send comments and bug fixes to larrosa@kde.org
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/shm.h>
#include <sys/wait.h>
#include <sys/stat.h>

#include <tqkeycode.h>
#include <tqstring.h>

#include <tdeaccel.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdecmdlineargs.h>
#include <tdefiledialog.h>
#include <tdefontdialog.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdetoolbar.h>
#include <kurl.h>
#include <kdebug.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <kurldrag.h>
#include <kedittoolbar.h>
#include <dcopclient.h>

#include "tdemidframe.h"
#include "tdemidclient.h"
#include "midicfgdlg.h"
#include "collectdlg.h"
#include "channelcfgdlg.h"
#include "channelview.h"
#include "version.h"

tdemidFrame::tdemidFrame(const char *name)
    :TDEMainWindow(0, name)
{
    tdemidclient=new tdemidClient(this,actionCollection(), "KMidClient");
    tdemidclient->setSongType(1);
    tdemidclient->show();
    setCentralWidget( tdemidclient );
/*
    kKeysAccel=new TDEAccel(this);
    kKeysAccel->insertItem(i18n("Play/Pause"),"Play/Pause", Key_Space);
    kKeysAccel->connectItem("Play/Pause", TQT_TQOBJECT(this), TQT_SLOT(spacePressed()));
    kKeysAccel->insertItem(i18n("Stop"),"Stop", Key_Backspace);
    kKeysAccel->connectItem("Stop",tdemidclient,TQT_SLOT(song_Stop()));
    kKeysAccel->insertItem(i18n("Previous Song"),"Previous Song", Key_Left);
    kKeysAccel->connectItem("Previous Song",tdemidclient,TQT_SLOT(song_PlayPrevSong()));
    kKeysAccel->insertItem(i18n("Next Song"),"Next Song", Key_Right);
    kKeysAccel->connectItem("Next Song",tdemidclient,TQT_SLOT(song_PlayNextSong()));
    kKeysAccel->insertItem(i18n("Scroll Down Karaoke"),"Scroll down karaoke",Key_Down);
    kKeysAccel->connectItem("Scroll Down karaoke",tdemidclient->getKDisplayText(),TQT_SLOT(ScrollDown()));
    kKeysAccel->insertItem(i18n("Scroll Up Karaoke"),"Scroll up karaoke",Key_Up);
    kKeysAccel->connectItem("Scroll Up Karaoke",tdemidclient->getKDisplayText(),TQT_SLOT(ScrollUp()));
    kKeysAccel->insertItem(i18n("Scroll Page Down Karaoke"),"Scroll page down karaoke",Key_PageDown);
    kKeysAccel->connectItem("Scroll Page Down Karaoke",tdemidclient->getKDisplayText(),TQT_SLOT(ScrollPageDown()));
    kKeysAccel->insertItem(i18n("Scroll Page Up Karaoke"),"Scroll page up karaoke",Key_PageUp);
    kKeysAccel->connectItem("Scroll Page Up Karaoke",tdemidclient->getKDisplayText(),TQT_SLOT(ScrollPageUp()));

    kKeysAccel->readSettings();
*/
    KStdAction::open(TQT_TQOBJECT(this), TQT_SLOT(file_Open()), actionCollection());
    (void)new TDEAction(i18n("&Save Lyrics..."), 0, TQT_TQOBJECT(this),
	TQT_SLOT(file_SaveLyrics()), actionCollection(), "file_save_lyrics");
    KStdAction::quit(TQT_TQOBJECT(kapp), TQT_SLOT(quit()), actionCollection());

    (void)new TDEAction(i18n("&Play"), "media-playback-start", TQt::Key_Space,
		TQT_TQOBJECT(tdemidclient), TQT_SLOT(slotPlay()), actionCollection(), "song_play");
    (void)new TDEAction(i18n("P&ause"), "media-playback-pause", TQt::Key_P, TQT_TQOBJECT(tdemidclient),
			TQT_SLOT(slotPause()), actionCollection(), "song_pause");
    (void)new TDEAction(i18n("&Stop"), "media-playback-stop", TQt::Key_Backspace,
		TQT_TQOBJECT(tdemidclient), TQT_SLOT(slotStop()), actionCollection(), "song_stop");

    (void)new TDEAction(i18n("P&revious Song"), "media-skip-backward", Key_Left,
		TQT_TQOBJECT(tdemidclient), TQT_SLOT(slotPrevSong()), actionCollection(),
		"song_previous");
    (void)new TDEAction(i18n("&Next Song"), "media-skip-forward", Key_Right,
		TQT_TQOBJECT(tdemidclient), TQT_SLOT(slotNextSong()), actionCollection(),
		"song_next");
    (void)new TDEToggleAction(i18n("&Loop"), 0, TQT_TQOBJECT(this), TQT_SLOT(song_Loop()),
		actionCollection(), "song_loop");

    (void)new TDEAction(i18n("Rewind"), "2leftarrow", 0, TQT_TQOBJECT(tdemidclient),
		TQT_SLOT(slotRewind()), actionCollection(), "song_rewind");

    (void)new TDEAction(i18n("Forward"), "2rightarrow", 0, TQT_TQOBJECT(tdemidclient),
		TQT_SLOT(slotForward()), actionCollection(), "song_forward");

    (void)new TDEAction(i18n("&Organize..."), 0, TQT_TQOBJECT(this), TQT_SLOT(collect_organize()),
		actionCollection(), "collect_organize");

    TQStringList playmodes;
    playmodes.append(i18n("In Order"));
    playmodes.append(i18n("Shuffle"));

    TDESelectAction *act=new TDESelectAction(i18n("Play Order"), 0, /*this, TQT_SLOT(collect_PlayOrder(int)),*/
                      actionCollection(), "play_order");
    connect(act,TQT_SIGNAL(activated(int)),this, TQT_SLOT(collect_PlayOrder(int)));
    act->setItems(playmodes);

    (void)new TDEToggleAction(i18n("Auto-Add to Collection"), 0, TQT_TQOBJECT(this),
	TQT_SLOT(collect_AutoAdd()), actionCollection(), "collect_autoadd");

    playmodes.clear();
    playmodes.append(i18n("&General MIDI"));
    playmodes.append(i18n("&MT-32"));

    act=new TDESelectAction(i18n("File Type"), 0,/* this, TQT_SLOT(options_FileType(int)),*/
                      actionCollection(), "file_type");
    connect(act,TQT_SIGNAL(activated(int)),this, TQT_SLOT(options_FileType(int)));
    act->setItems(playmodes);

    playmodes.clear();
    playmodes.append(i18n("&Text Events"));
    playmodes.append(i18n("&Lyric Events"));

    act=new TDESelectAction(i18n("Display Events"), Key_T, /*this,
		TQT_SLOT(options_DisplayEvents(int)),*/ actionCollection(),
		"display_events");
    connect(act,TQT_SIGNAL(activated(int)),this, TQT_SLOT(options_DisplayEvents(int)));
    act->setItems(playmodes);

    (void)new TDEToggleAction(i18n("Automatic Text Chooser"), 0, TQT_TQOBJECT(this),
		TQT_SLOT(options_AutomaticText()), actionCollection(),
		"option_automatictext");

    TDEToggleAction* togact = new TDEToggleAction(i18n("Show &Volume Bar"), "volume",
		0, TQT_TQOBJECT(this), TQT_SLOT(options_ShowVolumeBar()), actionCollection(),
		"toggle_volumebar");
    togact->setCheckedState(i18n("Hide &Volume Bar"));

    togact = new TDEToggleAction(i18n("Show &Channel View"), "piano",
		0, TQT_TQOBJECT(this), TQT_SLOT(options_ShowChannelView()), actionCollection(),
		"toggle_channelview");
    togact->setCheckedState(i18n("Hide &Channel View"));

    (void)new TDEAction(i18n("Channel View &Options..."), 0, TQT_TQOBJECT(this),
		TQT_SLOT(options_ChannelViewOptions()), actionCollection(),
		"channelview_options");

    (void)new TDEAction(i18n("&Font Change..."), 0, TQT_TQOBJECT(this),
		TQT_SLOT(options_FontChange()), actionCollection(),
		"change_font");

    (void)new TDEAction(i18n("MIDI &Setup..."), 0, TQT_TQOBJECT(this),
		TQT_SLOT(options_MidiSetup()), actionCollection(), "midi_setup");


    setupGUI((ToolBar | Keys | StatusBar | Save | Create ), "tdemidui.rc" );

    TDEConfig *cfg=kapp->config();
    cfg->setGroup("KMid");
    TDESelectAction *tmplistaction=
		((TDESelectAction*)actionCollection()->action("display_events"));

    if (cfg->readNumEntry("TypeOfTextEvents",5)==5)
        tmplistaction->setCurrentItem(1);
    else
        tmplistaction->setCurrentItem(0);

    tmplistaction=((TDESelectAction*)actionCollection()->action("file_type"));
    if (cfg->readNumEntry("TypeOfMidiFile",0)==0)
        tmplistaction->setCurrentItem(0);
    else
        tmplistaction->setCurrentItem(1);

    if (cfg->readNumEntry("Loop",0)==1)
	((TDEToggleAction*)actionCollection()->action("song_loop"))->setChecked(true);

    if (cfg->readNumEntry("ShowVolumeBar",0)==1)
	((TDEToggleAction*)actionCollection()->action("toggle_volumebar"))->setChecked(true);


    tmplistaction=((TDESelectAction*)actionCollection()->action("play_order"));
    if (cfg->readNumEntry("CollectionPlayMode",0)==0)
        tmplistaction->setCurrentItem(0);
    else
        tmplistaction->setCurrentItem(1);

    if ((cfg->readNumEntry("AutoAddToCollection",0))==1)
	((TDEToggleAction*)actionCollection()->action("collect_autoadd"))->setChecked(true);

    if ((cfg->readNumEntry("AutomaticTextEventChooser",1))==1)
	((TDEToggleAction*)actionCollection()->action("option_automatictext"))->setChecked(true);

    setAcceptDrops(true);

    connect( tdemidclient, TQT_SIGNAL( mustRechooseTextEvent() ),
             this, TQT_SLOT( rechooseTextEvent() ) );

    connect( tdemidclient, TQT_SIGNAL( stopPause() ),
             this, TQT_SLOT( song_stopPause() ) );

//    connect( tdemidclient, TQT_SIGNAL( channelView_Destroyed() ),
//             this, TQT_SLOT( channelViewDestroyed() ) );

    TDECmdLineArgs * args = TDECmdLineArgs::parsedArgs();

    if ( args->count() > 0 )
    {
//        printf("Opening command line file...\n");
        int backautoadd=cfg->readNumEntry("AutoAddToCollection",0);
        cfg->writeEntry("AutoAddToCollection",0);

        char ttt[40];
        sprintf(ttt,"%d",kapp->argc());
        int i=0;
        int c=autoAddSongToCollection( args->url( 0 ).path() , 1 );
        i++;
        while (i<args->count())
        {
            autoAddSongToCollection( args->url( i ).path() , 0 );
            i++;
        }

        tdemidclient->setActiveCollection(c);

        ///	    tdemidclient->openURL((kapp->argv())[1]);
        /*	    if ((cfg->readNumEntry("AutomaticTextEventChooser",1))==1)
         {
         if (tdemidclient->ChooseTypeOfTextEvents()==1)
         options_Text();
         else
         options_Lyrics();
         }*/
        if (tdemidclient->midiFileName()!=NULL) tdemidclient->play();
        cfg->writeEntry("AutoAddToCollection",backautoadd);
    }

    args->clear();
        /*
         kKeys->addKey("Play/Pause",Key_Space);
         kKeys->registerWidget("KMidFrame",this);
         kKeys->connectFunction("KMidFrame","Play/Pause",this,TQT_SLOT(spacePressed()));
         */
//    kKeysAccel->writeSettings(cfg);

    DCOPClient *client = kapp->dcopClient();
    if (!client->isRegistered())  // just in case we're embeeded
    {
      client->attach();
      client->registerAs("tdemid");
    }
}

tdemidFrame::~tdemidFrame()
{
}

void tdemidFrame::file_Open()
{
  KURL url = KFileDialog::getOpenURL(TQString(), "*.kar *.mid *.kar.gz *.mid.gz\n*.kar *.kar.gz\n*.mid *.mid.gz\n*",this);

  if( url.isEmpty() )
    return;

  if( !url.isLocalFile() )
  {
    KMessageBox::sorry( 0L, i18n( "Only local files are currently supported." ) );
    return;
  }

  openURL(url.path());
}



void tdemidFrame::song_stopPause()
{
  if (tdemidclient->isPaused())
  {
    //   song_Pause();
    ((TDEToggleAction*)actionCollection()->action("song_pause"))->setChecked(false);
    tdemidclient->pause();
  }
}

void tdemidFrame::options_FileType(int i)
{
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  cfg->writeEntry("TypeOfMidiFile",i);
  tdemidclient->setSongType(1-i);
}

void tdemidFrame::options_DisplayEvents(int i)
{
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  cfg->writeEntry("TypeOfTextEvents",(i==0)?1:5);
  cfg->sync();
  tdemidclient->repaintText((i==0)?1:5);
}

void tdemidFrame::options_AutomaticText()
{
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  cfg->writeEntry("AutomaticTextEventChooser",1-cfg->readNumEntry("AutomaticTextEventChooser",1));
}

void tdemidFrame::options_FontChange()
{
  TDEFontDialog *kfd=new TDEFontDialog(this);
  TQFont font;
  font=*tdemidclient->getFont();
  kfd->getFont(font);
  delete kfd;
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  cfg->writeEntry("KaraokeFont",font);
  cfg->sync();
  tdemidclient->fontChanged();
}

int tdemidFrame::autoAddSongToCollection(const TQString& filename,int setactive)
{
  int r;
  SLManager *slman;
  SongList *sl;
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  if (cfg->readNumEntry("AutoAddToCollection",0)==0)
  {
    r=0;
    slman=tdemidclient->getSLManager();
    if (setactive) slman->createTemporaryCollection();
    sl=slman->getCollection(0);
    if (filename==NULL) sl->AddSong(tdemidclient->midiFileName());
    else sl->AddSong(TQFile::encodeName(filename));
  }
  else
  {
    slman=tdemidclient->getSLManager();
    sl=slman->getCollection(tdemidclient->getActiveCollection());
    r=tdemidclient->getActiveCollection();
    if (sl==NULL) return 0;
    int id;
    if (filename==NULL) id=sl->AddSong(tdemidclient->midiFileName());
    else id=sl->AddSong(TQFile::encodeName(filename));
    if (setactive)
    {
      sl->setActiveSong(id);
    }
  }
  return r;
}

void tdemidFrame::urlDrop_slot(TQDropEvent* e)
{
  dropEvent(e);
}

void tdemidFrame::dragEnterEvent(TQDragEnterEvent* e)
{
  e->accept(KURLDrag::canDecode(e));
}

void tdemidFrame::dropEvent( TQDropEvent * event )
{
  KURL::List list;
  KURLDrag::decode(event, list);

  if (list.count()==0) return;

  bool first = true;
  int c = true;

  for (KURL::List::ConstIterator it = list.begin();
       it != list.end(); ++it)
  {
     if (!(*it).isLocalFile())
        continue;

     if (first)
     {
         c = autoAddSongToCollection((*it).path(),1);
         first = false;
     }
     else
     {
         autoAddSongToCollection((*it).path(),0);
     }
  }

  if (!first)
  {
     tdemidclient->setActiveCollection(c);

     if ((!tdemidclient->isPlaying())&&(tdemidclient->midiFileName()!=NULL))
		tdemidclient->play();
  }
}

void tdemidFrame::shuttingDown()
{
   if (tdemidclient->isPlaying()==1)
   {
//      tdemidclient->stop();
      tdemidclient->shuttingDown();
   }
   tdemidclient->saveCollections();
}

void tdemidFrame::saveProperties(TDEConfig *cfg)
{
  tdemidclient->saveCollections();
  int play=tdemidclient->isPlaying();
  cfg->writeEntry("File",tdemidclient->midiFileName());
  cfg->writeEntry("ActiveCollection",tdemidclient->getActiveCollection());
  cfg->writeEntry("ActiveSong",tdemidclient->getSelectedSong());
  cfg->writeEntry("Playing",play);
}

void tdemidFrame::readProperties(TDEConfig *cfg)
{
  int activecol=cfg->readNumEntry("ActiveCollection",0);
  int activesong=cfg->readNumEntry("ActiveSong",0);
  int wasplaying=cfg->readNumEntry("Playing",0);
  SLManager *slman=tdemidclient->getSLManager();
  SongList *sl=slman->getCollection(activecol);
  sl->setActiveSong(activesong);
  tdemidclient->setActiveCollection(activecol);
  tdemidclient->slotSelectSong(activesong-1);

  if ((activecol==0)&&(wasplaying)) // It was the temporary collection,
  {		// surely the user would like to continue
    // hearing the song
    TQString s = cfg->readPathEntry("File");
    int c=autoAddSongToCollection(s,1);
    tdemidclient->setActiveCollection(c);
  }

  if ((wasplaying)&&(tdemidclient->midiFileName()!=NULL)) tdemidclient->play();
}

void tdemidFrame::options_MidiSetup()
{
  if (tdemidclient->devman()->checkInit()<0)
  {
    KMessageBox::error(this,
	i18n("Could not open /dev/sequencer to get some info.\nProbably there is another program using it."));
    return;
  }
  MidiConfigDialog *dlg;

  dlg=new MidiConfigDialog(tdemidclient->devman(),NULL,"MidiDialog");
  if (dlg->exec() == TQDialog::Accepted)
  {
    TDEConfig *cfg=kapp->config();
    cfg->setGroup("KMid");
    cfg->writeEntry("MidiPortNumber",MidiConfigDialog::selecteddevice);
    tdemidclient->setMidiDevice(MidiConfigDialog::selecteddevice);
    cfg->setGroup("Midimapper");
    cfg->writePathEntry("LoadFile",
	(MidiConfigDialog::selectedmap==NULL)? TQString():MidiConfigDialog::selectedmap);
    tdemidclient->setMidiMapFilename(MidiConfigDialog::selectedmap);
  }
  delete dlg;
}

void tdemidFrame::collect_organize()
{
  CollectionDialog *dlg;
  SLManager *slman=new SLManager(*tdemidclient->getSLManager());
  int idx=tdemidclient->getActiveCollection();

  dlg=new CollectionDialog(slman,idx,NULL,"MidiDialog");
  if (dlg->exec() == TQDialog::Accepted)
    {
    tdemidclient->setSLManager(slman);
    tdemidclient->setActiveCollection(CollectionDialog::selectedC);
    tdemidclient->slotSelectSong(
     (slman->getCollection(CollectionDialog::selectedC))->getActiveSongID()-1);
    }
   else
    {
    delete slman;
    }
delete dlg;
}

void tdemidFrame::rechooseTextEvent()
{
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  if ((cfg->readNumEntry("AutomaticTextEventChooser",1))==1)
  {
    int t=tdemidclient->ChooseTypeOfTextEvents();
    tdemidclient->repaintText(t);
    if (t==1)
      ((TDESelectAction*)actionCollection()->action("display_events"))->setCurrentItem(0);
    else
      ((TDESelectAction*)actionCollection()->action("display_events"))->setCurrentItem(1);
  }
}

void tdemidFrame::song_Loop()
{
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  int i=1-cfg->readNumEntry("Loop",0);
  cfg->writeEntry("Loop",i);
  cfg->sync();
  tdemidclient->setSongLoop(i);
}

void tdemidFrame::collect_PlayOrder(int i)
{
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  cfg->writeEntry("CollectionPlayMode", i);
  cfg->sync();
  tdemidclient->setCollectionPlayMode(i);
}

void tdemidFrame::collect_AutoAdd()
{
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  cfg->writeEntry("AutoAddToCollection",1-cfg->readNumEntry("AutoAddToCollection",0));
  cfg->sync();
}

void tdemidFrame::file_SaveLyrics()
{
  KURL url = KFileDialog::getSaveURL(TQString(),"*",this);

  if( url.isEmpty() )
    return;

  if( !url.isLocalFile() )
  {
    KMessageBox::sorry( 0L, i18n( "Only local files are currently supported." ) );
    return;
  }

  TQString filename = url.path();
  struct stat statbuf;

  if (stat(TQFile::encodeName(filename), &statbuf)!=-1)
  {
    TQString s = i18n("File %1 already exists\nDo you want to overwrite it?").arg(filename);
    if (KMessageBox::warningYesNo(this,s,TQString(),i18n("Overwrite"),KStdGuiItem::cancel())==1)
      return;
  }

  FILE *fh=fopen(TQFile::encodeName(filename),"wt");
  tdemidclient->saveLyrics(fh);
  fclose(fh);
}

void tdemidFrame::spacePressed()
{
  if (!tdemidclient->isPlaying()) tdemidclient->play();
  else pause();
}
void tdemidFrame::options_ShowVolumeBar()
{
  TDEConfig *cfg=kapp->config();
  cfg->setGroup("KMid");
  int i=1-cfg->readNumEntry("ShowVolumeBar",0);
  cfg->writeEntry("ShowVolumeBar",i);
  tdemidclient->visibleVolumeBar(i);
}

void tdemidFrame::options_ShowChannelView()
{
  if (!((TDEToggleAction*)actionCollection()->action("toggle_channelview"))->isChecked())
  {
    tdemidclient->visibleChannelView(0);
  } else
  {
    tdemidclient->visibleChannelView(1);
    connect (tdemidclient->getChannelView(),TQT_SIGNAL(destroyMe()),this,TQT_SLOT(channelViewDestroyed()));
  }

}

void tdemidFrame::channelViewDestroyed()
{
  tdemidclient->channelViewDestroyed();
  ((TDEToggleAction*)actionCollection()->action("toggle_channelview"))->setChecked(false);
}

void tdemidFrame::options_ChannelViewOptions()
{
  ChannelViewConfigDialog *dlg;

  dlg=new ChannelViewConfigDialog(NULL,"ChannelViewConfigDialog");
  if (dlg->exec() == TQDialog::Accepted)
  {
    if (tdemidclient->getChannelView())
      tdemidclient->getChannelView()->lookMode(
	  ChannelViewConfigDialog::selectedmode );
  }
  delete dlg;
}

void tdemidFrame::openURL( const TQString url )
{
  int c=autoAddSongToCollection(url,1);
  tdemidclient->setActiveCollection(c);
}

/*void tdemidFrame::play()
{
  tdemidclient->play();
}

void tdemidFrame::pause()
{
//  tdemidclient->pause();
  ((TDEAction*)actionCollection()->action("pause"))->activate();
}

void tdemidFrame::stop()
{
  tdemidclient->stop();
}

void tdemidFrame::rewind()
{
  tdemidclient->rewind();
}

void tdemidFrame::forward()
{
  tdemidclient->forward();
}

void tdemidFrame::seek(int ms)
{
  tdemidclient->timebarChange(ms);
}

void tdemidFrame::prevSong()
{
  tdemidclient->prevSong();
}

void tdemidFrame::nextSong()
{
  tdemidclient->nextSong();
}

void tdemidFrame::setSongLoop(int i)
{
  ((TDEToggleAction*)actionCollection()->action("song_loop"))->setChecked(i!=0);
}

void tdemidFrame::setVolume(int i)
{
  tdemidclient->volumebarChange(200-i);
}

void tdemidFrame::setTempo(int i)
{
  tdemidclient->changeTempo(i);
}

void tdemidFrame::setSongType( int i )
{
  TDESelectAction *tmplistaction=
    ((TDESelectAction*)actionCollection()->action("file_type"));

  tmplistaction->setCurrentItem(i);
}

void tdemidFrame::setLyricEvents( int i )
{
  TDESelectAction *tmplistaction=
    ((TDESelectAction*)actionCollection()->action("display_events"));
  tmplistaction->setCurrentItem(i);
}

void tdemidFrame::selectSong(int i)
{
  tdemidclient->getComboSongs()->setCurrentItem(i-1);
  tdemidclient->selectSong(i-1);
}

void tdemidFrame::setActiveCollection( int i )
{
  tdemidclient->setActiveCollection(i);
}

void tdemidFrame::setCollectionPlayMode(int i)
{
  ((TDESelectAction*)actionCollection()->action("play_order"))->setCurrentItem(i);
}

void tdemidFrame::setMidiDevice(int i)
{


}
*/


#include "tdemidframe.moc"
