#include "pref.h"

#include <tdelocale.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <tqlayout.h>
//#include <tqlabel.h>
#include "cmodule.h"

NoatunPreferences::NoatunPreferences(TQWidget *parent)
    : KDialogBase(TreeList, i18n("Preferences - Noatun"),
                  Ok|Apply|Cancel|Help, Ok, parent, "NoatunPreferences", false, true)
{
	resize(640, 480); // KDE is required to support 800x600 min.
	setShowIconsInTreeList(true);
	setRootIsDecorated(false);
}

void NoatunPreferences::slotOk()
{
	slotApply();
	hide();
}

void NoatunPreferences::show()
{
	for (CModule *i=mModules.first(); i != 0; i=mModules.next())
		i->reopen();
	KDialogBase::show();
}

void NoatunPreferences::show(CModule *page)
{
	int index = pageIndex( static_cast<TQWidget *>(TQT_TQWIDGET(page->parent())) );
	if (index != -1)
		showPage(index);
	show();
}

void NoatunPreferences::slotApply()
{
	for (CModule *i=mModules.first(); i != 0; i=mModules.next())
		i->save();
}

void NoatunPreferences::add(CModule *page)
{
	mModules.append(page);
}

void NoatunPreferences::remove(CModule *page)
{
	mModules.removeRef(page);
}

CModule::CModule(const TQString &name, const TQString &description, const TQString &icon, TQObject *owner)
	: TQWidget(napp->preferencesBox()->addPage(name, description, TDEGlobal::iconLoader()->loadIcon(
		icon, TDEIcon::Small,0, TDEIcon::DefaultState,0, true)))
{
	if (owner)
		connect(owner, TQT_SIGNAL(destroyed()), TQT_SLOT(ownerDeleted()));

	//kdDebug(66666) << k_funcinfo << "name = " << name << endl;

	napp->preferencesBox()->add(this);

	TQFrame *page=static_cast<TQFrame*>(TQT_TQWIDGET(parent()));
	(new TQHBoxLayout(page))->addWidget(this);
}

CModule::~CModule()
{
	//kdDebug(66666) << k_funcinfo << endl;

	napp->preferencesBox()->remove(this);
}

void CModule::ownerDeleted()
{
	TQObject *p=parent();
	delete this;
	p->deleteLater();
}

#include "pref.moc"
