/*
  Copyright (C) 2005 Richard Lärkäng <nouseforaname@home.se>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#include <tqcombobox.h>
#include <tqlistbox.h>
#include <tqlabel.h>
#include <tqtextcodec.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <kcharsets.h>
#include "cdinfoencodingwidget.h"

namespace KCDDB
{
  CDInfoEncodingWidget::CDInfoEncodingWidget(TQWidget* parent, const TQString& artist,
          const TQString& title, const TQStringList& songTitles)
    : CDInfoEncodingWidgetBase(parent), m_artist(artist), m_title(title),
        m_songTitles(songTitles)
  {
    encodingCombo->insertStringList(TDEGlobal::charsets()->descriptiveEncodingNames());

    slotEncodingChanged(encodingCombo->currentText());

    connect(encodingCombo,TQT_SIGNAL(activated(const TQString&)),
        this,TQT_SLOT(slotEncodingChanged(const TQString&)));
  }

  TQString CDInfoEncodingWidget::selectedEncoding()
  {
    return encodingCombo->currentText();
  }

  void CDInfoEncodingWidget::slotEncodingChanged(const TQString& encoding)
  {
    KCharsets* charsets = TDEGlobal::charsets();
    
    TQTextCodec* codec = charsets->codecForName(charsets->encodingForName(encoding));
    
    songsBox->clear();
    TQStringList newTitles;

    for (TQStringList::const_iterator it = m_songTitles.begin();
        it != m_songTitles.end(); ++it)
      newTitles << codec->toUnicode((*it).latin1());

    songsBox->clear();
    songsBox->insertStringList(newTitles);
      
    titleLabel->setText(i18n("artist - cdtitle", "%1 - %2").arg(
          codec->toUnicode(m_artist.latin1()), codec->toUnicode(m_title.latin1())));
  }
}

#include "cdinfoencodingwidget.moc"
