/***************************************************************************
    copyright            : (C) 2004 by Scott Wheeler
    email                : wheeler@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "folderplaylist.h"
#include "playlistcollection.h"

#include <tqtimer.h>

////////////////////////////////////////////////////////////////////////////////
// public methods
////////////////////////////////////////////////////////////////////////////////

FolderPlaylist::FolderPlaylist(PlaylistCollection *collection, const TQString &folder,
                               const TQString &name) :
    Playlist(collection, name, "folder"),
    m_folder(folder)
{
    TQTimer::singleShot(0, this, TQT_SLOT(slotReload()));
}

FolderPlaylist::~FolderPlaylist()
{

}

TQString FolderPlaylist::folder() const
{
    return m_folder;
}

void FolderPlaylist::setFolder(const TQString &s)
{
    m_folder = s;
    TQTimer::singleShot(0, this, TQT_SLOT(slotReload()));
}

////////////////////////////////////////////////////////////////////////////////
// private slots
////////////////////////////////////////////////////////////////////////////////

void FolderPlaylist::slotReload()
{
    if(!m_folder.isNull())
        addFiles(m_folder);
}

////////////////////////////////////////////////////////////////////////////////
// helper functions
////////////////////////////////////////////////////////////////////////////////

TQDataStream &operator<<(TQDataStream &s, const FolderPlaylist &p)
{
    s << p.name()
      << p.folder();
    return s;
}

TQDataStream &operator>>(TQDataStream &s, FolderPlaylist &p)
{
    TQString name;
    TQString folder;
    s >> name
      >> folder;

    p.setFolder(folder);
    p.setName(name);
    return s;
}

#include "folderplaylist.moc"
