    /*

    Copyright ( C ) 2002, 2003 Arnold Krille <arnold@arnoldarts.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or ( at your option ) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

    */

#ifndef TDEPOPUPBOX_PRIVATE_H
#define TDEPOPUPBOX_PRIVATE_H


class HandleDrag;
class ShowButton;
class OwnButton;
class KArtsWidget;
class OwnWidget;
class TQBoxLayout;

#include <tqframe.h>

class TDEPopupBox_widget : public TQFrame
{
   TQ_OBJECT
  
public:
	TDEPopupBox_widget( TQWidget* =0, const char* =0);
	~TDEPopupBox_widget();

	Arts::Direction direction();
	void direction( Arts::Direction );

	void setWidget( Arts::Widget widget );
	Arts::Widget getWidget();

	void name( std::string );
private slots:
	void hide( bool );
	void own( bool );
private:
	TQBoxLayout *_layout;

	TQFrame *_titlebar;
	TQBoxLayout *_titlebarlayout;
	HandleDrag *_drag;
	ShowButton *_showbutton;
	OwnButton *_ownbutton;

	OwnWidget *_artswidget;
};

// See tdepopupbox_impl.h - The eventmapper isn't needed at present, but perhaps in the future...

/*class TDEPopupBoxEventMapper : public TQObject {
   TQ_OBJECT
  
public:
	TDEPopupBoxEventMapper(  TDEPopupBox_widget *widget, Arts::TDEPopupBox_impl *impl )
	  : TQObject(  widget,"" ), _widget(  widget ), _impl(  impl )
	{}
private:
	TDEPopupBox_widget *_widget;
	Arts::TDEPopupBox_impl *_impl;
};*/

#include <tqpainter.h>
#include <tqstyle.h>

class HandleDrag : public TQWidget {
   TQ_OBJECT
  
public:
	HandleDrag( TQWidget *parent, const char* name=0 ) : TQWidget( parent,name ) {}
	void paintEvent( TQPaintEvent * ) {
		TQPainter p( this );
		TQStyle::SFlags flags = TQStyle::Style_Default;
		if( width() < height() ) flags |= TQStyle::Style_Horizontal;
		style().tqdrawPrimitive( TQStyle::PE_DockWindowHandle, &p, rect(), colorGroup(), flags );
	}
signals:
	void clicked();
protected:
	virtual void mouseDoubleClickEvent( TQMouseEvent * ) {
		emit clicked();
	}
};

static const char* const close_xpm[]  = { "5 5 2 1", "# c black", ". c None", "#...#", ".#.#.", "..#..", ".#.#.", "#...#"};
static const char* const up_xpm[]     = { "5 5 2 1", "# c black", ". c None", ".....", "..#..", ".###.", "#####", "....."};
static const char* const down_xpm[]   = { "5 5 2 1", "# c black", ". c None", ".....", "#####", ".###.", "..#..", "....."};
static const char* const left_xpm[]   = { "5 5 2 1", "# c black", ". c None", "...#.", "..##.", ".###.", "..##.", "...#."};
static const char* const right_xpm[]  = { "5 5 2 1", "# c black", ". c None", ".#...", ".##..", ".###.", ".##..", ".#..."};
static const char* const inside_xpm[] = { "5 5 2 1", "# c black", ". c None", "#####", "#...#", "#...#", "#...#", "#####"};
static const char* const own_xpm[]    = { "5 5 2 1", "# c black", ". c None", "###..", "#.###", "###.#", ".#..#", ".####"};

#include <tqpushbutton.h>
#include <tqlayout.h>

class ShowButton : public TQPushButton {
   TQ_OBJECT
  
private:
	TQBoxLayout::Direction _dir;
	TQPixmap _pmleft, _pmright, _pmup, _pmdown;
public:
	ShowButton( TQWidget *parent, const char* name=0 ) : TQPushButton( parent,name ), _dir( TQBoxLayout::LeftToRight )
	{
		connect( this, TQT_SIGNAL( toggled( bool ) ), this, TQT_SLOT( owntoggle( bool ) ) );
		setToggleButton( true );
		_pmleft = TQPixmap( const_cast<const char**>( left_xpm ) );
		_pmright = TQPixmap( const_cast<const char**>( right_xpm ) );
		_pmup = TQPixmap( const_cast<const char**>( up_xpm ) );
		_pmdown = TQPixmap( const_cast<const char**>( down_xpm ) );
		setPixmap( _pmright );
	}

	void direction( TQBoxLayout::Direction n ) { _dir=n; }
public slots:
	void owntoggle( bool b ) {
		switch( _dir )
		{
			case TQBoxLayout::BottomToTop:
				if( b ) setPixmap( _pmdown );
				else setPixmap( _pmup );
				break;
			case TQBoxLayout::TopToBottom:
				if( b ) setPixmap( _pmup );
				else setPixmap( _pmdown );
				break;
			case TQBoxLayout::LeftToRight:
				if( b ) setPixmap( _pmright );
				else setPixmap( _pmleft );
				break;
			case TQBoxLayout::RightToLeft:
				if( b ) setPixmap( _pmleft );
				else setPixmap( _pmright );
				break;
		}
	}
public:
	TQSize minimumSizeHint() const {
		int wh = style().pixelMetric( TQStyle::PM_DockWindowHandleExtent, this );
		return TQSize( wh, wh );
	}
	TQSizePolicy sizePolicy() const { return TQSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed ); }
	TQSize minimumSize() const { return minimumSizeHint(); }
	TQSize sizeHint() const { return minimumSize(); }

	void drawButton(  TQPainter * p )
	{
		p->fillRect( 0,0, width(), height(), TQBrush( colorGroup().brush( TQColorGroup::Background ) ) );
		p->drawPixmap( ( width() - pixmap()->width() ) / 2, ( height() - pixmap()->height() ) / 2, *pixmap() );
	}
};

class OwnButton : public TQPushButton {
   TQ_OBJECT
  
private:
	TQPixmap _pmown, _pminside;
public:
	OwnButton( TQWidget *parent, const char* name=0 ) : TQPushButton( parent,name )
	{
		connect( this, TQT_SIGNAL( toggled( bool ) ), this, TQT_SLOT( toggle( bool ) ) );
		setToggleButton( true );
		_pmown = TQPixmap( const_cast<const char**>( own_xpm ) );
		_pminside = TQPixmap( const_cast<const char**>( inside_xpm ) );
		setPixmap( _pmown );
	}

public slots:
	void toggle( bool b ) {
			if( b ) setPixmap( _pminside );
			else setPixmap(  _pmown );
	}
public:
	TQSize minimumSizeHint() const {
		int wh = style().pixelMetric( TQStyle::PM_DockWindowHandleExtent, this );
		return TQSize( wh, wh );
	}
	TQSizePolicy sizePolicy() const { return TQSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed ); }
	TQSize minimumSize() const { return minimumSizeHint(); }
	TQSize sizeHint() const { return minimumSize(); }

	void drawButton( TQPainter * p )
	{
		p->fillRect( 0,0, width(), height(), TQBrush( colorGroup().brush( TQColorGroup::Background ) ) );
		p->drawPixmap( ( width() - pixmap()->width() ) / 2, ( height() - pixmap()->height() ) / 2, *pixmap() );
	}
};

#include <kartswidget.h>

class OwnWidget : public KArtsWidget
{
   TQ_OBJECT
  
	ShowButton *_b;
public:
	OwnWidget( ShowButton* b, TQWidget* p, const char* n=0, WFlags f=0 ) : KArtsWidget( p,n,f ) { _b = b; }
	~OwnWidget() {}
public slots:
	void closeEvent( TQCloseEvent * ) { _b->toggle(); }
};

#endif
