/***************************************************************************
                          percentageeditor.cpp  -  description
                             -------------------
    begin                : lun ago 9 2004
    copyright            : (C) 2004 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "percentageeditor.h"
#include "propertysetter.h"

percentageEditor::percentageEditor(const TQString& initialValue, TQWidget *parent, const char *name) : miniEditor(parent,name)
{
  TQString temp(initialValue);
  m_sb = new mySpinBox(0,9999,1,this);
  m_sb->setValue(temp.remove("%").toInt());
  m_sb->setSuffix("%");
  connect(m_sb, TQT_SIGNAL(valueChanged ( const TQString & )), this, TQT_SIGNAL(valueChanged(const TQString&)));
}

percentageEditor::~percentageEditor()
{
  delete m_sb;
}

void percentageEditor::connectToPropertySetter(propertySetter* p){
  connect( this, TQT_SIGNAL(valueChanged(const TQString&)), p, TQT_SIGNAL(valueChanged(const TQString&)));
}

#include "percentageeditor.moc"
