/***************************************************************************
                          doubleeditors.cpp  -  description
                             -------------------
    begin                : dom ago 3 2003
    copyright            : (C) 2003 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 #include "doubleeditors.h"
 #include "specialsb.h"
 #include <tqcombobox.h>
 #include "csseditor_globals.h"
 #include "propertysetter.h"
 #include <tqregexp.h>



doubleEditorBase::doubleEditorBase(TQWidget *parent, const char *name) : miniEditor(parent,name){
}

void doubleEditorBase::sxValueSlot(const TQString& v){
  m_sxValue=v;
  emit valueChanged( m_sxValue +" " + m_dxValue);
}

void doubleEditorBase::dxValueSlot(const TQString& v){
  m_dxValue=v;
  emit valueChanged( m_sxValue +" " + m_dxValue);
}

 doubleLengthEditor::doubleLengthEditor(TQWidget *parent, const char *name) : doubleEditorBase(parent,name){

  m_ssbSx = new specialSB(this);
  m_ssbSx->insertItem("cm");
  m_ssbSx->insertItem("em");
  m_ssbSx->insertItem("ex");
  m_ssbSx->insertItem("in");
  m_ssbSx->insertItem("mm");
  m_ssbSx->insertItem("pc");
  m_ssbSx->insertItem("pt");
  m_ssbSx->insertItem("px");

  m_ssbDx = new specialSB(this);
  m_ssbDx->insertItem("cm");
  m_ssbDx->insertItem("em");
  m_ssbDx->insertItem("ex");
  m_ssbDx->insertItem("in");
  m_ssbDx->insertItem("mm");
  m_ssbDx->insertItem("pc");
  m_ssbDx->insertItem("pt");
  m_ssbDx->insertItem("px");

  connect(m_ssbSx, TQT_SIGNAL(valueChanged(const TQString&)), this, TQT_SLOT(sxValueSlot(const TQString&)));
  connect(m_ssbDx, TQT_SIGNAL(valueChanged(const TQString&)), this, TQT_SLOT(dxValueSlot(const TQString&)));
}

doubleLengthEditor::~doubleLengthEditor(){
  delete m_ssbSx;
  delete m_ssbDx;
}

void doubleLengthEditor::connectToPropertySetter(propertySetter* p){
  connect(this, TQT_SIGNAL(valueChanged(const TQString&)), p ,TQT_SIGNAL(valueChanged(const TQString&)));
}

void doubleLengthEditor::setInitialValue(const TQString& sx, const TQString& dx){
  m_ssbSx->setInitialValue(sx);
  m_ssbDx->setInitialValue(dx);
}

doubleComboBoxEditor::doubleComboBoxEditor(TQWidget *parent, const char *name) : doubleEditorBase(parent,name){
  m_cbSx = new TQComboBox(this);
  m_cbDx = new TQComboBox(this);
  connect(m_cbSx, TQT_SIGNAL(activated ( const TQString & )), this, TQT_SLOT(sxValueSlot(const TQString&)));
  connect(m_cbDx, TQT_SIGNAL(activated ( const TQString & )), this, TQT_SLOT(dxValueSlot(const TQString&)));
}

doubleComboBoxEditor::~doubleComboBoxEditor(){
  delete m_cbSx;
  delete m_cbDx;
}

void doubleComboBoxEditor::connectToPropertySetter(propertySetter* p){
  connect(this, TQT_SIGNAL(valueChanged(const TQString&)), p ,TQT_SIGNAL(valueChanged(const TQString&)));
}

doublePercentageEditor::doublePercentageEditor(TQWidget *parent, const char *name) : doubleEditorBase(parent,name){
  m_sbSx = new mySpinBox(this);
  m_sbDx = new mySpinBox(this);
  m_sbSx->setSuffix("%");
  m_sbDx->setSuffix("%");
  connect(m_sbSx,TQT_SIGNAL(valueChanged(const TQString&)),this,TQT_SLOT(sxValueSlot(const TQString&)));
  connect(m_sbDx,TQT_SIGNAL(valueChanged(const TQString&)),this,TQT_SLOT(dxValueSlot(const TQString&)));
}

doublePercentageEditor::~doublePercentageEditor(){
  delete m_sbSx;
  delete m_sbDx;
}

void doublePercentageEditor::connectToPropertySetter(propertySetter* p){
  connect(this, TQT_SIGNAL(valueChanged(const TQString&)), p ,TQT_SIGNAL(valueChanged(const TQString&)));
}

void doublePercentageEditor::setInitialValue(const TQString& a_sx, const TQString& a_dx){
  TQString sx = a_sx;
  TQString dx = a_dx;
  m_sbSx->setValue(sx.remove("%").toInt());
  m_sbDx->setValue(dx.remove("%").toInt());
}

#include "doubleeditors.moc"
