/***************************************************************************
                         progressbar.cpp - ProgressBar widget 
                             -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* KDE INCLUDES */
#include <tdelocale.h>

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "progressbar.h"
#include "kommanderplugin.h"

enum Functions {
  FirstFunction = 585,
  PB_setHighlightColor,
  PB_setHightlightTextColor,
  LastFunction
};

ProgressBar::ProgressBar(TQWidget *a_parent, const char *a_name)
  : KProgress(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(PB_setHighlightColor, "setBarColor(TQString widget, TQString Color)",  i18n("Sets the ProgresBar color"), 2);
  KommanderPlugin::registerFunction(PB_setHightlightTextColor, "setBarTextColor(TQString widget, TQString Color)",  i18n("Sets the ProgresBar text color"), 2);
}

ProgressBar::~ProgressBar()
{
}

TQString ProgressBar::currentState() const
{
  return TQString("default");
}

bool ProgressBar::isKommanderWidget() const
{
  return true;
}

TQStringList ProgressBar::associatedText() const
{
  return KommanderWidget::associatedText();
}

void ProgressBar::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void ProgressBar::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString ProgressBar::populationText() const
{
  return KommanderWidget::populationText();
}

void ProgressBar::populate()
{
  setProgress(KommanderWidget::evalAssociatedText(populationText()).toUInt());
}

void ProgressBar::showEvent(TQShowEvent *e)
{
  TQProgressBar::showEvent(e);
  emit widgetOpened();
}

bool ProgressBar::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::clear || f == DCOP::setMaximum || f == DCOP::geometry || (f > FirstFunction && f < LastFunction);
}

TQString ProgressBar::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return TQString::number(progress());
    case DCOP::setText:
      setProgress(args[0].toUInt());
      break;
    case DCOP::clear:
      setProgress(0);
      break;
    case DCOP::setMaximum:
      setTotalSteps(args[0].toUInt());
      break;
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case PB_setHighlightColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      TQPalette p = this->palette();
      p.setColor(TQPalette::Active, TQColorGroup::Highlight, color);
      this->setPalette( p, TRUE );
      break;
    }
    case PB_setHightlightTextColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      TQPalette p = this->palette();
      p.setColor(TQPalette::Active, TQColorGroup::HighlightedText, color);
      this->setPalette( p, TRUE );
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "progressbar.moc"
