/***************************************************************************
                          closebutton.cpp - Button that when clicked, closes the dialog it's in
                          -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* KDE INCLUDES */
#include <tdemessagebox.h>
#include <tdelocale.h>

/* QT INCLUDES */
#include <tqdialog.h>
#include <tqevent.h>
#include <tqobject.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqwidget.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "closebutton.h"

CloseButton::CloseButton(TQWidget* a_parent, const char* a_name)
  : KPushButton(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  setWriteStdout(true);

  connect(this, TQT_SIGNAL(clicked()), this, TQT_SLOT(startProcess()));

  TQObject *parent = TQT_TQOBJECT(this);
  while (parent->parent() != 0)
  {
    parent = parent->parent();
    if (parent->inherits("TQDialog"))
      break;
  }
  connect(this, TQT_SIGNAL(clicked()), parent, TQT_SLOT(reject()));
}

CloseButton::~CloseButton()
{
}

TQString CloseButton::currentState() const
{
  return TQString("default");
}

bool CloseButton::isKommanderWidget() const
{
  return true;
}

TQStringList CloseButton::associatedText() const
{
  return KommanderWidget::associatedText();
}

void CloseButton::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void CloseButton::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString CloseButton::populationText() const
{
  return KommanderWidget::populationText();
}

void CloseButton::populate()
{
  setWidgetText(KommanderWidget::evalAssociatedText(populationText()));
}

void CloseButton::setWidgetText(const TQString& a_text)
{
  setText(a_text);
  emit widgetTextChanged(a_text);
}

void CloseButton::startProcess()
{
  TQString at = evalAssociatedText();

  if (!at.isEmpty())
  {
    KShellProcess *process = new KShellProcess("/bin/sh");
    *process << at;

    connect(process, TQT_SIGNAL(processExited(TDEProcess *)), TQT_SLOT(endProcess(TDEProcess *)));
    connect(process, TQT_SIGNAL(receivedStdout(TDEProcess *, char *, int)), TQT_SLOT(appendOutput(TDEProcess *,
                char *, int)));
    connect(process, TQT_SIGNAL(receivedStderr(TDEProcess *, char *, int)), TQT_SLOT(appendOutput(TDEProcess *,
                char *, int)));

    if (!process->start(TDEProcess::Block, TDEProcess::Stdout))
    {
      KMessageBox::error(this, i18n("Failed to start shell process."));
      endProcess(process);
      return;
    }
  } else
    endProcess(0);
}

void CloseButton::appendOutput(TDEProcess *, char *a_buffer, int a_len)
{
  char *buffer = new char[a_len + 1];
  buffer[a_len] = 0;
  for (int i = 0; i < a_len; ++i)
    buffer[i] = a_buffer[i];

  TQString bufferString(buffer);
  m_output += bufferString;
  if (writeStdout())
  {
    fputs(buffer, stdout);
    fflush(stdout);
  }
  delete[] buffer;
}

void CloseButton::endProcess(TDEProcess *a_process)
{
  emit widgetTextChanged(m_output);
  m_output = "";
  delete a_process;
}

bool CloseButton::writeStdout() const
{
  return m_writeStdout;
}

void CloseButton::setWriteStdout(bool a_enable)
{
  m_writeStdout = a_enable;
}

void CloseButton::showEvent(TQShowEvent *e)
{
  TQPushButton::showEvent(e);
  emit widgetOpened();
}

bool CloseButton::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText;
}

TQString CloseButton::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return m_output;
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "closebutton.moc"
