/***************************************************************************
  mainwindow.cpp - Kommander plugin manager mainwindow class implementation
                             -------------------
    begin                : Tue Aug 13 09:31:50 EST 2002
    copyright            : (C) 2004 by Marc Britton
    email                : consume@optushome.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mainwindow.h"
#include "pluginmanager.h"

#include <tdetoolbar.h>
#include <tdelistbox.h>
#include <tdeconfig.h>
#include <tdefiledialog.h>
#include <klibloader.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeglobal.h>
#include <kstandarddirs.h>

MainWindow::MainWindow( TQWidget* parent, const char *name, WFlags f )
    : TDEMainWindow( parent, name, f )
{
  TDEToolBar *toolBar = new TDEToolBar( this );
  toolBar->insertButton("document-open", Add, true, i18n("Add") );
  toolBar->insertButton("no", Remove, true, i18n("Remove") );
  toolBar->insertButton("reload", Refresh, true, i18n("Refresh") );
  connect( toolBar, TQT_SIGNAL(clicked(int)), this, TQT_SLOT(toolButton(int)) );

  m_list = new TDEListBox( this );
  setCentralWidget(m_list);
  
  m_pluginManager = new PluginManager;
  m_list->insertStringList(m_pluginManager->items());
}

MainWindow::~MainWindow()
{
  delete m_pluginManager;
}

void MainWindow::toolButton( int id )
{
  switch (id)
  {
    case Add: 
      add();
      break;
    case Remove:
      remove();
      break;
    case Refresh:
      verify();
      break;
  }
}

void MainWindow::add()
{
  TQString libDir = TDEGlobal::dirs()->findResourceDir("lib", "libkommanderplugin");
  TQString plugin = KFileDialog::getOpenFileName(libDir, "lib*", this, 
    i18n("Add Kommander Plugin"));
  add(plugin);
}

void MainWindow::add(const TQString &plugin)
{
  if (!m_pluginManager->add(plugin))
  {
    TQString errMsg = i18n("<qt>Unable to load Kommander plugin<br><b>%1</b></qt>").arg(plugin);
    KMessageBox::error(this, errMsg, i18n("Cannot add plugin"));
  }
  else
    refresh();
}

void MainWindow::remove()
{
  TQString plugin = m_list->currentText();
  if (m_pluginManager->remove(plugin))
    refresh();
}

void MainWindow::refresh()
{
  m_list->clear();
  m_list->insertStringList(m_pluginManager->items()); 
}

void MainWindow::verify()
{
  m_pluginManager->verify();
  refresh();
}

#include "mainwindow.moc"
