/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
/* Modifications by Marc Britton (c) 2002-2003 under GNU GPL, terms as above */

#ifndef _HAVE_KOMMANDERFACTORY_H_
#define _HAVE_KOMMANDERFACTORY_H_

#include <tqstring.h>
#include <tqptrlist.h>
#include <tqimage.h>
#include <tqpixmap.h>
#include <tqvaluelist.h>
#include <tqmap.h>
#include <tqaction.h>
#include "kommander_export.h"

class TQWidget;
class TQLayout;
class TQDomElement;
class TQListViewItem;
class TQTable;
class TQIconSet;
class KommanderPlugin;

struct KommanderWidgetInfo
{
    KommanderWidgetInfo() {}
    KommanderWidgetInfo( const TQString &g, const TQString &t, TQIconSet *i, const TQString &w = TQString(), bool c = FALSE )
	: group( g ), toolTip( t ), iconSet(i), whatsThis( w ), isContainer( c )
    {
    }
    TQString group;
    TQString toolTip;
    TQIconSet *iconSet;
    TQString whatsThis;
    bool isContainer;
};
typedef TQMap<TQString, KommanderWidgetInfo> FeatureList;

class KOMMANDER_EXPORT KommanderFactory
{
public:
    KommanderFactory();
    virtual ~KommanderFactory();

    static TQWidget *create( const TQString &uiFile, TQObject *connector = 0, TQWidget *parent = 0, const char *name = 0 );
    static TQWidget *create( TQIODevice *dev, TQObject *connector = 0, TQWidget *parent = 0, const char *name = 0 );
    static int loadPlugins( bool force = FALSE );
    static void addPlugin( KommanderPlugin *plugin );
    static void loadImages( const TQString &dir );

    static TQWidget *createWidget( const TQString &className, TQWidget *parent, const char *name );

    static FeatureList featureList();
private:
    enum LayoutType { HBox, VBox, Grid, NoLayout };
    void loadImageCollection( const TQDomElement &e );
    void loadConnections( const TQDomElement &e, TQObject *connector );
    void loadTabOrder( const TQDomElement &e );
    TQWidget *createWidgetInternal( const TQDomElement &e, TQWidget *parent, TQLayout* layout, const TQString &classNameArg );
    TQLayout *createLayout( TQWidget *widget, TQLayout*  layout, LayoutType type );
    LayoutType layoutType( TQLayout *l ) const;
    void setProperty( TQObject* widget, const TQString &prop, const TQDomElement &e );
    void createSpacer( const TQDomElement &e, TQLayout *layout );
    TQImage loadFromCollection( const TQString &name );
    TQPixmap loadPixmap( const TQDomElement &e );
    TQColorGroup loadColorGroup( const TQDomElement &e );
    void createColumn( const TQDomElement &e, TQWidget *widget );
    void loadItem( const TQDomElement &e, TQPixmap &pix, TQString &txt, bool &hasPixmap );
    void createItem( const TQDomElement &e, TQWidget *widget, TQListViewItem *i = 0 );
    void loadChildAction( TQObject *parent, const TQDomElement &e );
    void loadActions( const TQDomElement &e );
    void loadToolBars( const TQDomElement &e );
    void loadMenuBar( const TQDomElement &e );
    TQAction *findAction( const TQString &name );
    TQString translate( const TQString& sourceText, const TQString& comment = "" );

private:
    struct Image {
	TQImage img;
	TQString name;
	bool operator==(  const Image &i ) const {
	    return ( i.name == name &&
		     i.img == img );
	}
    };

    struct Field
    {
	Field() {}
	Field( const TQString &s1, const TQPixmap &p, const TQString &s2 ) : name( s1 ), pix( p ), field( s2 ) {}
	TQString name;
	TQPixmap pix;
	TQString field;
#if defined(TQ_FULL_TEMPLATE_INSTANTIATION)
	bool operator==( const Field& ) const { return FALSE; }
#endif
    };

    struct EventFunction
    {
	EventFunction() {}
	EventFunction( const TQString &e, const TQStringList &f )
	    : events( e ) { functions.append( f ); }
	TQStringList events;
	TQValueList<TQStringList> functions;
    };

    struct SqlWidgetConnection
    {
	SqlWidgetConnection() {}
	SqlWidgetConnection( const TQString &c, const TQString &t )
	    : conn( c ), table( t ), dbControls( new TQMap<TQString, TQString>() ) {}
	TQString conn;
	TQString table;
	TQMap<TQString, TQString> *dbControls;
    };

    struct Functions
    {
	TQString functions;
    };

    TQValueList<Image> images;
    TQWidget *toplevel;
    TQListViewItem *lastItem;
    TQMap<TQString, TQString> *dbControls;
    TQMap<TQString, TQStringList> dbTables;
    TQMap<TQWidget*, SqlWidgetConnection> sqlWidgetConnections;
    TQMap<TQString, TQString> buddies;
    TQMap<TQTable*, TQValueList<Field> > fieldMaps;
    TQPtrList<TQAction> actionList;
   TQMap<TQObject *, EventFunction> eventMap;
    TQMap<TQString, TQString> languageSlots;
    TQMap<TQString, Functions*> languageFunctions;
    TQStringList variables;
    TQStringList noDatabaseWidgets;
    bool usePixmapCollection;
    int defMargin, defSpacing;

};

#endif
