/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>
    Copyright (c) 2004 Till Adam <adam@kde.org>
    Copyright (c) 2005 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "tdeabc_resourcegroupwarebaseconfig.h"

#include "tdeabc_resourcegroupwarebase.h"
#include "tderesources_groupwareprefs.h"
#include "folderconfig.h"

#include <kdebug.h>
#include <kdialog.h>
#include <tdelocale.h>
#include <klineedit.h>
#include <kurlrequester.h>

#include <tqlabel.h>
#include <tqlayout.h>

using namespace TDEABC;

ResourceGroupwareBaseConfig::ResourceGroupwareBaseConfig( TQWidget* parent,  const char* name )
  : KRES::ConfigWidget( parent, name )
{
  TQGridLayout *mainLayout = new TQGridLayout( this, 7, 2, 0, KDialog::spacingHint() );

  TQLabel *label = new TQLabel( i18n( "URL:" ), this );
  mURL = new KURLRequester( this );

  mainLayout->addWidget( label, 0, 0 );
  mainLayout->addWidget( mURL, 0, 1 );

  label = new TQLabel( i18n( "User:" ), this );
  mUser = new KLineEdit( this );

  mainLayout->addWidget( label, 1, 0 );
  mainLayout->addWidget( mUser, 1, 1 );

  label = new TQLabel( i18n( "Password:" ), this );
  mPassword = new KLineEdit( this );
  mPassword->setEchoMode( TQLineEdit::Password );

  mainLayout->addWidget( label, 2, 0 );
  mainLayout->addWidget( mPassword, 2, 1 );

  TQFrame *hline = new TQFrame( this );
  hline->setFrameStyle( TQFrame::HLine | TQFrame::Sunken );

  mainLayout->addMultiCellWidget( hline, 3, 3, 0, 1 );

  mFolderConfig = new KPIM::FolderConfig( this );
  connect( mFolderConfig, TQT_SIGNAL( updateFoldersClicked() ),
    TQT_SLOT( updateFolders() ) );
  mainLayout->addMultiCellWidget( mFolderConfig, 4, 4, 0, 1 );
}

void ResourceGroupwareBaseConfig::loadSettings( KRES::Resource *res )
{
  mResource = dynamic_cast<ResourceGroupwareBase*>( res );
  
  if ( !mResource ) {
    kdDebug(5700) << "ResourceGroupwareBaseConfig::loadSettings(): cast failed" << endl;
    return;
  }

  mURL->setURL( mResource->prefs()->url() );
  mUser->setText( mResource->prefs()->user() );
  mPassword->setText( mResource->prefs()->password() );

  mFolderConfig->setFolderLister( mResource->folderLister() );
  mFolderConfig->updateFolderList();
}

void ResourceGroupwareBaseConfig::saveSettings( KRES::Resource *res )
{
  ResourceGroupwareBase *resource = dynamic_cast<ResourceGroupwareBase*>( res );
  
  if ( !resource ) {
    kdDebug(5700) << "ResourceGroupwareBaseConfig::saveSettings(): cast failed" << endl;
    return;
  }

  resource->prefs()->setUrl( mURL->url() );
  resource->prefs()->setUser( mUser->text() );
  resource->prefs()->setPassword( mPassword->text() );  

  mFolderConfig->saveSettings();
}

void ResourceGroupwareBaseConfig::updateFolders()
{
  KURL url = mURL->url();
  url.setUser( mUser->text() );
  url.setPass( mPassword->text() );

  mFolderConfig->retrieveFolderList( url );
}

#include "tdeabc_resourcegroupwarebaseconfig.moc"
