#ifndef BASE_FACTORY_H
#define BASE_FACTORY_H

#include <tqglobal.h>

#include <kdemacros.h>

struct MainData {
    const char *appName, *trName, *description, *homepage, *removedLabel,
        *version, *longVersion;
};

struct BaseBoardInfo {
    uint width, height;
    bool withPieces;

    uint beforeRemoveTime, afterRemoveTime;
    uint nbToggles, nbFallStages;

    uint nbArcadeStages;

    const uint *histogram;
    uint histogramSize;
    bool scoreBound;
};

class BaseBoard;
class BaseInterface;
class TQWidget;
class TDEAboutData;

#define bfactory BaseFactory::self()

class KDE_EXPORT BaseFactory
{
 public:
    BaseFactory(const MainData &, const BaseBoardInfo &);
    virtual ~BaseFactory();
    void init(int argc, char **argv);

    static BaseFactory *self() { return _self; }

    const MainData      &mainData;
    const BaseBoardInfo &bbi;

    virtual BaseBoard *createBoard(bool graphic, TQWidget *parent) = 0;
    virtual BaseInterface *createInterface(TQWidget *parent) = 0;

    virtual TQWidget *createAppearanceConfig();
    virtual TQWidget *createColorConfig();
    virtual TQWidget *createGameConfig() { return 0; }
 
 protected:
    TDEAboutData *_aboutData;

 private:
    static BaseFactory *_self;
};

#endif
