#include <tdelocale.h>
#include <tdeaccel.h>
#include <kkeydialog.h>
#include <tdeaction.h>
#include <kstdgameaction.h>
#include <tqlayout.h>
#include <kstatusbar.h>

#include "topwidget.h"
#include "mainview.h"
#include "playerinfo.h"

MyTopLevelWidget::MyTopLevelWidget()
{
   initGameWidgets();
   initStatusBar( );
   initActions( );
   setupGUI( );
}

void MyTopLevelWidget::initGameWidgets( ){
   TQWidget *w = new TQWidget(this);

   playerinfo[0]=new PlayerInfo(0,w);
   playerinfo[1]=new PlayerInfo(1,w);
   playfield=new MyMainView(w);

   TQBoxLayout *toplayout=new TQHBoxLayout(w);
   toplayout->addWidget(playerinfo[0]);
   toplayout->addWidget(playfield);
   toplayout->addWidget(playerinfo[1]);
   toplayout->activate();

   playfield->setFocusPolicy(TQWidget::StrongFocus);
   playfield->setFocus();

   TQObject::connect(TQT_TQOBJECT(playfield),TQT_SIGNAL(energy(int,int)),
                    TQT_SLOT(energy(int,int)));
   TQObject::connect(TQT_TQOBJECT(playfield),TQT_SIGNAL(hitPoints(int,int)),
                    TQT_SLOT(hitPoints(int,int)));
   TQObject::connect(TQT_TQOBJECT(playfield),TQT_SIGNAL(wins(int,int)),TQT_SLOT(wins(int,int)));
   TQObject::connect(TQT_TQOBJECT(playfield),TQT_SIGNAL(setStatusText(const TQString &,int)),
                    TQT_SLOT(setStatusText(const TQString &,int)));

   setCentralWidget(w);
}

void MyTopLevelWidget::energy(int pn,int en)
{
   playerinfo[pn]->setEnergy(en);
}

void MyTopLevelWidget::hitPoints(int pn,int hp)
{
   playerinfo[pn]->setHitpoints(hp);
}

void MyTopLevelWidget::wins(int pn,int w)
{
   playerinfo[pn]->setWins(w);
}

void MyTopLevelWidget::initActions( )
{
   KStdGameAction::quit(TQT_TQOBJECT(this), TQT_SLOT(close()), actionCollection());
   KStdGameAction::gameNew(TQT_TQOBJECT(playfield), TQT_SLOT(newGame()), actionCollection());
   ( void )new TDEAction( i18n( "&New Round" ), "spnewround",
                        CTRL + Key_R, TQT_TQOBJECT(playfield), TQT_SLOT( newRound( ) ),
                        actionCollection( ), "new_round" );
   MyMainView::pauseAction =
       KStdGameAction::pause(TQT_TQOBJECT(playfield), TQT_SLOT(togglePause()), actionCollection());
   MyMainView::pauseAction->setChecked( false );
   TDEAction* gameStart = new TDEAction( i18n( "Start" ), GAME_START_SHORTCUT,
	   TQT_TQOBJECT(playfield), TQT_SLOT( start( ) ), actionCollection( ), "game_start" );

   KStdAction::preferences(TQT_TQOBJECT(playfield), TQT_SLOT(gameSetup()), actionCollection());

   TDEAccel* acc = new TDEAccel(this);
   gameStart->plugAccel(acc);

   // Default keys
   actionCollection()->setAutoConnectShortcuts(false);
   TDEAction* ac;
   ac = new TDEAction(i18n("Player 1 Rotate Left"), Key_S, 0, 0,
		    actionCollection(), "P1KeyLeft");
   ac->setEnabled( false );
   ac = new TDEAction(i18n("Player 1 Rotate Right"), Key_F, 0, 0,
		     actionCollection(), "P1KeyRight");
   ac->setEnabled( false );
   ac = new TDEAction(i18n("Player 1 Accelerate"), Key_E, 0, 0,
		    actionCollection(), "P1KeyAcc");
   ac->setEnabled( false );
   ac = new TDEAction(i18n("Player 1 Shot"), Key_D, 0, 0,
		    actionCollection(), "P1Shot");
   ac->setEnabled( false );
   ac = new TDEAction(i18n("Player 1 Mine"), Key_A, 0, 0,
		    actionCollection(), "P1Mine");
   ac->setEnabled( false );

   ac = new TDEAction(i18n("Player 2 Rotate Left"), Key_Left, 0, 0,
		    actionCollection(), "P2KeyLeft");
   ac->setEnabled( false );
   ac = new TDEAction(i18n("Player 2 Rotate Right"), Key_Right, 0, 0,
		    actionCollection(), "P2KeyRight");
   ac->setEnabled( false );
   ac = new TDEAction(i18n("Player 2 Accelerate"), Key_Up, 0, 0,
		    actionCollection(), "P2KeyAcc");
   ac->setEnabled( false );
   ac = new TDEAction(i18n("Player 2 Shot"), Key_Down, 0, 0,
		    actionCollection(), "P2Shot");
   ac->setEnabled( false );
   ac = new TDEAction(i18n("Player 2 Mine"), Key_Insert, 0, 0,
		    actionCollection(), "P2Mine");
   ac->setEnabled( false );

   actionCollection()->setAutoConnectShortcuts(true);
   playfield->setActionCollection(actionCollection());
}

void MyTopLevelWidget::initStatusBar( )
{
   statusBar( )->insertItem(i18n(" paused "),IDS_PAUSE,1);
   statusBar( )->insertItem("   ",IDS_MAIN,1);
   statusBar( )->insertItem("",42,2);
}

void MyTopLevelWidget::start()
{
   playfield->newGame();
   playfield->newRound();
}

void MyTopLevelWidget::setStatusText(const TQString & str,int id)
{
   statusBar( )->changeItem(str,id);
}

void MyTopLevelWidget::keySetup()
{
   playfield->pause();
   KKeyDialog::configure( actionCollection( ), this, true );
}

#include "topwidget.moc"
