#include <kdialog.h>
#include <tdelistbox.h>

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqwidget.h>
#include <tqframe.h>

#include "editor.h"
#include "game.h"

Editor::Editor(ObjectList *list, TQWidget *parent, const char *name)
	: TQWidget(parent, name)
{
	this->list = list;
	config = 0;

	hlayout = new TQHBoxLayout(this, KDialog::marginHint(), KDialog::spacingHint());

	TQVBoxLayout *vlayout = new TQVBoxLayout(hlayout, KDialog::spacingHint());
	vlayout->addWidget(new TQLabel(i18n("Add object:"), this));
	listbox = new TDEListBox(this, "Listbox");
	vlayout->addWidget(listbox);
	hlayout->setStretchFactor(vlayout, 2);

	TQStringList items;
	Object *obj = 0;
	for (obj = list->first(); obj; obj = list->next())
		items.append(obj->name());

	listbox->insertStringList(items);

	connect(listbox, TQT_SIGNAL(executed(TQListBoxItem *)), TQT_SLOT(listboxExecuted(TQListBoxItem *)));
}

void Editor::listboxExecuted(TQListBoxItem * /*item*/)
{
	int curItem = listbox->currentItem();
	if (curItem < 0)
		return;

	emit addNewItem(list->at(curItem));
}

void Editor::setItem(CanvasItem *item)
{
	delete config;
	config = item->config(this);
	if (!config)
		return;
	config->ctorDone();
	hlayout->addWidget(config);
	hlayout->setStretchFactor(config, 2);
	config->setFrameStyle(TQFrame::Box | TQFrame::Raised);
	config->setLineWidth(1);
	config->show();
	connect(config, TQT_SIGNAL(modified()), this, TQT_SIGNAL(changed()));
}

#include "editor.moc"
