/***************************************************************************
    begin                : Fri May 19 2000
    copyright            : (C) 2000 by Roman Razilov
    email                : Roman.Razilov@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLINES_H
#define KLINES_H

#include <tdemainwindow.h>

#include "linesboard.h"
#include "mwidget.h"
#include "prompt.h"

class TDESelectAction;
class TDEAction;
class TDEToggleAction;

class KLines : public TDEMainWindow
{
  TQ_OBJECT
  
public:
  KLines();
  ~KLines();

protected:
  void keyPressEvent(TQKeyEvent *e);
  void initTDEAction();
  void setLevel(int level);

  void focusOutEvent(TQFocusEvent *);
  void focusInEvent(TQFocusEvent *);

public slots:
  void startGame();
  void startDemo();
  void stopGame();
  void endGame();
  void makeTurn();
  void userTurn();
  void addScore(int ballsErased);
  void switchPrompt();
  void switchNumbered();
  void undo();
  void slotDemo();

private slots:
  void viewHighScore();

private:
  LinesBoard* lsb;
  MainWidget *mwidget;
  LinesPrompt *lPrompt;
  TDEAction *act_demo, *undoAction, *endTurnAction;
  TDESelectAction *levelAction;
  TDEToggleAction *showNextAction;
  TDEToggleAction *showNumberedAction;
  TQString levelStr;

  bool bNewTurn;

  int score;
  int score_undo;

  int nextBalls[BALLSDROP];
  int nextBalls_undo[BALLSDROP];
  int nextBalls_redo[BALLSDROP];
  bool bUndo;
  bool bFirst;
  bool bDemo;

  int demoStep;
  TQTimer demoTimer;

  void searchBallsLine();
  void generateRandomBalls();
  void placeBalls();
  void updateStat();
  void switchUndo( bool bu );
  void stopDemo();
};

#endif
